$(function(){
	show();
	seriesLastNum('tbl_nbt_time','NTM-','#formNBTTime','input[name="nbt_time_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formNBTTime').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveNBTTime', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#nbt_time_table').on('click','.updateNbtTime',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('nbtTimeId');
		var nbtTimeNo = $(this).closest('tr').find('td:nth-child(1)').html();
		var from = $(this).closest('tr').find('td:nth-child(2)').html();
		var to = $(this).closest('tr').find('td:nth-child(3)').html();
		var description = $(this).closest('tr').find('td:nth-child(4)').html();
		var status = $(this).closest('tr').find('td:nth-child(5)').html();

		$('#updateNBTTime').find('input[name="nbt_time_id"]').val(id);
		$('#updateNBTTime').find('input[name="nbt_time_no"]').val(nbtTimeNo);
		$('#updateNBTTime').find('input[name="from"]').val(from);
		$('#updateNBTTime').find('input[name="to"]').val(to);
		$('#updateNBTTime').find('input[name="description"]').val(description);

		if(status == 'enabled'){
			$('#updateNBTTime').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateNBTTime').find('input[name="status"]').bootstrapToggle('off'); 
		}
	})
	$('#updateNBTTime').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateNbtTime', data)
			.done(function(returnData){;
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});
function tConvert(time) {
	  // Check correct time format and split into components
	  time = time.toString ().match (/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

	  if (time.length > 1) { // If time format correct
	    time = time.slice (1);  // Remove full string match value
	    time[5] = +time[0] < 12 ? ' AM' : ' PM'; // Set AM/PM
	    time[0] = +time[0] % 12 || 12; // Adjust hours
	  }
	  return time.join('').replace(":00 ", " "); // return adjusted time or original string
	}
function show(){
	tableLoader('#nbt_time_table');
	$.post(URL+'setup/showNbtTime')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.nbtTimeNo+"</td>"+
							"<td>"+tConvert(a.from)+"</td>"+
							"<td>"+tConvert(a.to)+"</td>"+
							"<td>"+a.description+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a nbtTimeId='"+a.id+"' class='updateNbtTime btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";
		});
		$('.nbtTImeData').html(append);
		$('#nbt_time_table').DataTable({
			    "ordering": false
		});
	})
}	