<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblBudgetHoursPerPositionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblBudgetHoursPerPosition 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblBudgetHoursPerPosition primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblBudgetHoursPerPosition tblBudgetHoursPerPosition
 	 */
	public function insert($tblBudgetHoursPerPosition);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblBudgetHoursPerPosition tblBudgetHoursPerPosition
 	 */
	public function update($tblBudgetHoursPerPosition);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEngagementSetupId($value);

	public function queryByPositionId($value);

	public function queryByBudgetHours($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByEngagementSetupId($value);

	public function deleteByPositionId($value);

	public function deleteByBudgetHours($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>