$(function(){
	getSubdomain();
	$('#table_dpr').on('click', '.dprview', function(){
		$('#reportModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('nbtid');
		dprReportSummary(id);
	});

	$('#generateDpr').submit(function(){
		$('#table_dpr').DataTable().destroy();
		tableLoader('#table_dpr');
		var form = $(this).serialize();
		$.post(URL + 'reports/generateDpr', form)
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data,function(key,a){
				status = a.nbt == 'done' ? "<button class='dprview alert-button-success btn btn-block' nbtid='"+a.nbt_id+"'>View</button>" : "<button class='alert-button-danger btn btn-block'>No Report</button>";
				append += "<tr>"+
								"<td>"+a.company_identification+"</td>"+
								"<td>"+a.name+"</td>"+
								"<td>"+a.position+"</td>"+
								"<td>"+status+"</td>"+
						"</tr>";
			})
			$('#table_dpr').find(".data_dpr").html(append);
			$('#table_dpr').DataTable({
			    "ordering": false  
			});
		})
		return false;
	})

	$('.btnExport').click(function(){
		subdomain = $("select[name='subdomain']").val();
		date = $('input[name="date"]').val();

		window.location = URL +"export/dpr?subdomain="+subdomain+"&date="+date;
	})

})
function getSubdomain(){
	$.post(URL + 'employee/showSubdomains')
	.done(function(returnData){
		var data = $.parseJSON(returnData);

		var append = '';
		$.each(data,function(key,a){
			append +=  '<option value="'+a.id+'">'+a.subdomain+'</option>';
		})
		$('#generateDpr').find('select[name=subdomain]').html(append);
		$('#generateDpr').find('select[name=subdomain]').selectpicker('refresh');
	})
}
function dprReportSummary(id){
	tableLoader('#dpr_summary_table');
	$.post(URL + 'reports/generateDprSummary', {'id': id})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data,function(key,a){
			append += "<tr>"+
								"<td>"+a.client+"</td>"+
								"<td>"+a.engagement+"</td>"+
								"<td>"+a.tba+"</td>"+
								"<td>"+a.nbt+"</td>"+
								"<td>"+a.target+"</td>"+
								"<td>"+a.actual+"</td>"+
						"</tr>";
		})
		$('#dpr_summary_table').find(".dprSummaryData").html(append);	
	})
}