<?php
/**
 * Class that operate on table 'tbl_transportation_mode'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblTransportationModeMySqlDAO implements TblTransportationModeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblTransportationModeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_transportation_mode';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_transportation_mode ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblTransportationMode primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTransportationModeMySql tblTransportationMode
 	 */
	public function insert($tblTransportationMode){
		$sql = 'INSERT INTO tbl_transportation_mode (transportation_no, transportation, status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblTransportationMode->transportationNo);
		$sqlQuery->set($tblTransportationMode->transportation);
		$sqlQuery->set($tblTransportationMode->status);
		$sqlQuery->setNumber($tblTransportationMode->createdBy);
		$sqlQuery->setNumber($tblTransportationMode->modifiedBy);
		$sqlQuery->set($tblTransportationMode->dateCreated);
		$sqlQuery->set($tblTransportationMode->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblTransportationMode->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTransportationModeMySql tblTransportationMode
 	 */
	public function update($tblTransportationMode){
		$sql = 'UPDATE tbl_transportation_mode SET transportation_no = ?, transportation = ?, status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblTransportationMode->transportationNo);
		$sqlQuery->set($tblTransportationMode->transportation);
		$sqlQuery->set($tblTransportationMode->status);
		$sqlQuery->setNumber($tblTransportationMode->createdBy);
		$sqlQuery->setNumber($tblTransportationMode->modifiedBy);
		$sqlQuery->set($tblTransportationMode->dateCreated);
		$sqlQuery->set($tblTransportationMode->dateModified);

		$sqlQuery->setNumber($tblTransportationMode->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_transportation_mode';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTransportationNo($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE transportation_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTransportation($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE transportation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_transportation_mode WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTransportationNo($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE transportation_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTransportation($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE transportation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_transportation_mode WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblTransportationModeMySql 
	 */
	protected function readRow($row){
		$tblTransportationMode = new TblTransportationMode();
		
		$tblTransportationMode->id = $row['id'];
		$tblTransportationMode->transportationNo = $row['transportation_no'];
		$tblTransportationMode->transportation = $row['transportation'];
		$tblTransportationMode->status = $row['status'];
		$tblTransportationMode->createdBy = $row['created_by'];
		$tblTransportationMode->modifiedBy = $row['modified_by'];
		$tblTransportationMode->dateCreated = $row['date_created'];
		$tblTransportationMode->dateModified = $row['date_modified'];

		return $tblTransportationMode;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblTransportationModeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>