<?php
/**
 * Class that operate on table 'tbl_daily_forecast'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-26 06:14
 */
class TblDailyForecastMySqlDAO implements TblDailyForecastDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDailyForecastMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_daily_forecast';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_daily_forecast ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDailyForecast primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDailyForecastMySql tblDailyForecast
 	 */
	public function insert($tblDailyForecast){
		$sql = 'INSERT INTO tbl_daily_forecast (subsync_id, subdomain, user_id, forecast_transaction_id, to_do_date, hour_code, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDailyForecast->subsyncId);
		$sqlQuery->setNumber($tblDailyForecast->subdomain);
		$sqlQuery->setNumber($tblDailyForecast->userId);
		$sqlQuery->setNumber($tblDailyForecast->forecastTransactionId);
		$sqlQuery->set($tblDailyForecast->toDoDate);
		$sqlQuery->set($tblDailyForecast->hourCode);
		$sqlQuery->setNumber($tblDailyForecast->createdBy);
		$sqlQuery->setNumber($tblDailyForecast->modifiedBy);
		$sqlQuery->set($tblDailyForecast->dateCreated);
		$sqlQuery->set($tblDailyForecast->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblDailyForecast->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDailyForecastMySql tblDailyForecast
 	 */
	public function update($tblDailyForecast){
		$sql = 'UPDATE tbl_daily_forecast SET subsync_id = ?, subdomain = ?, user_id = ?, forecast_transaction_id = ?, to_do_date = ?, hour_code = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDailyForecast->subsyncId);
		$sqlQuery->setNumber($tblDailyForecast->subdomain);
		$sqlQuery->setNumber($tblDailyForecast->userId);
		$sqlQuery->setNumber($tblDailyForecast->forecastTransactionId);
		$sqlQuery->set($tblDailyForecast->toDoDate);
		$sqlQuery->set($tblDailyForecast->hourCode);
		$sqlQuery->setNumber($tblDailyForecast->createdBy);
		$sqlQuery->setNumber($tblDailyForecast->modifiedBy);
		$sqlQuery->set($tblDailyForecast->dateCreated);
		$sqlQuery->set($tblDailyForecast->dateModified);

		$sqlQuery->setNumber($tblDailyForecast->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_daily_forecast';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByForecastTransactionId($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE forecast_transaction_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDoDate($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE to_do_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourCode($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_daily_forecast WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByForecastTransactionId($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE forecast_transaction_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDoDate($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE to_do_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourCode($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_daily_forecast WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDailyForecastMySql 
	 */
	protected function readRow($row){
		$tblDailyForecast = new TblDailyForecast();
		
		$tblDailyForecast->id = $row['id'];
		$tblDailyForecast->subsyncId = $row['subsync_id'];
		$tblDailyForecast->subdomain = $row['subdomain'];
		$tblDailyForecast->userId = $row['user_id'];
		$tblDailyForecast->forecastTransactionId = $row['forecast_transaction_id'];
		$tblDailyForecast->toDoDate = $row['to_do_date'];
		$tblDailyForecast->hourCode = $row['hour_code'];
		$tblDailyForecast->createdBy = $row['created_by'];
		$tblDailyForecast->modifiedBy = $row['modified_by'];
		$tblDailyForecast->dateCreated = $row['date_created'];
		$tblDailyForecast->dateModified = $row['date_modified'];

		return $tblDailyForecast;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDailyForecastMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>