<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-03-21 07:55
 */
interface TblCompanyPerEngDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblCompanyPerEng 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblCompanyPerEng primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblCompanyPerEng tblCompanyPerEng
 	 */
	public function insert($tblCompanyPerEng);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblCompanyPerEng tblCompanyPerEng
 	 */
	public function update($tblCompanyPerEng);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompanyId($value);

	public function queryByEngagementId($value);

	public function queryByClientId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByCompanyId($value);

	public function deleteByEngagementId($value);

	public function deleteByClientId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>