<?php
/**
 * Class that operate on table 'tbl_pajamas_brand_of_service'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblPajamasBrandOfServiceMySqlDAO implements TblPajamasBrandOfServiceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblPajamasBrandOfServiceMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblPajamasBrandOfService primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPajamasBrandOfServiceMySql tblPajamasBrandOfService
 	 */
	public function insert($tblPajamasBrandOfService){
		$sql = 'INSERT INTO tbl_pajamas_brand_of_service (user_id, greet_client, client_greet, client_name, provide_recommendation, reply_communication, exercise_humility, contact_name, email_address, subject, message, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPajamasBrandOfService->userId);
		$sqlQuery->set($tblPajamasBrandOfService->greetClient);
		$sqlQuery->set($tblPajamasBrandOfService->clientGreet);
		$sqlQuery->setNumber($tblPajamasBrandOfService->clientName);
		$sqlQuery->set($tblPajamasBrandOfService->provideRecommendation);
		$sqlQuery->set($tblPajamasBrandOfService->replyCommunication);
		$sqlQuery->set($tblPajamasBrandOfService->exerciseHumility);
		$sqlQuery->set($tblPajamasBrandOfService->contactName);
		$sqlQuery->set($tblPajamasBrandOfService->emailAddress);
		$sqlQuery->set($tblPajamasBrandOfService->subject);
		$sqlQuery->set($tblPajamasBrandOfService->message);
		$sqlQuery->set($tblPajamasBrandOfService->createdAt);
		$sqlQuery->set($tblPajamasBrandOfService->updatedAt);

		$id = $this->executeInsert($sqlQuery);	
		$tblPajamasBrandOfService->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPajamasBrandOfServiceMySql tblPajamasBrandOfService
 	 */
	public function update($tblPajamasBrandOfService){
		$sql = 'UPDATE tbl_pajamas_brand_of_service SET user_id = ?, greet_client = ?, client_greet = ?, client_name = ?, provide_recommendation = ?, reply_communication = ?, exercise_humility = ?, contact_name = ?, email_address = ?, subject = ?, message = ?, created_at = ?, updated_at = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPajamasBrandOfService->userId);
		$sqlQuery->set($tblPajamasBrandOfService->greetClient);
		$sqlQuery->set($tblPajamasBrandOfService->clientGreet);
		$sqlQuery->setNumber($tblPajamasBrandOfService->clientName);
		$sqlQuery->set($tblPajamasBrandOfService->provideRecommendation);
		$sqlQuery->set($tblPajamasBrandOfService->replyCommunication);
		$sqlQuery->set($tblPajamasBrandOfService->exerciseHumility);
		$sqlQuery->set($tblPajamasBrandOfService->contactName);
		$sqlQuery->set($tblPajamasBrandOfService->emailAddress);
		$sqlQuery->set($tblPajamasBrandOfService->subject);
		$sqlQuery->set($tblPajamasBrandOfService->message);
		$sqlQuery->set($tblPajamasBrandOfService->createdAt);
		$sqlQuery->set($tblPajamasBrandOfService->updatedAt);

		$sqlQuery->setNumber($tblPajamasBrandOfService->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGreetClient($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE greet_client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientGreet($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE client_greet = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientName($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE client_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProvideRecommendation($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE provide_recommendation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReplyCommunication($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE reply_communication = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExerciseHumility($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE exercise_humility = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContactName($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE contact_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmailAddress($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE email_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubject($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE subject = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMessage($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE message = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedAt($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE created_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUpdatedAt($value){
		$sql = 'SELECT * FROM tbl_pajamas_brand_of_service WHERE updated_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGreetClient($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE greet_client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientGreet($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE client_greet = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientName($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE client_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProvideRecommendation($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE provide_recommendation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReplyCommunication($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE reply_communication = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExerciseHumility($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE exercise_humility = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContactName($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE contact_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmailAddress($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE email_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubject($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE subject = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMessage($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE message = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedAt($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE created_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUpdatedAt($value){
		$sql = 'DELETE FROM tbl_pajamas_brand_of_service WHERE updated_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblPajamasBrandOfServiceMySql 
	 */
	protected function readRow($row){
		$tblPajamasBrandOfService = new TblPajamasBrandOfService();
		
		$tblPajamasBrandOfService->id = $row['id'];
		$tblPajamasBrandOfService->userId = $row['user_id'];
		$tblPajamasBrandOfService->greetClient = $row['greet_client'];
		$tblPajamasBrandOfService->clientGreet = $row['client_greet'];
		$tblPajamasBrandOfService->clientName = $row['client_name'];
		$tblPajamasBrandOfService->provideRecommendation = $row['provide_recommendation'];
		$tblPajamasBrandOfService->replyCommunication = $row['reply_communication'];
		$tblPajamasBrandOfService->exerciseHumility = $row['exercise_humility'];
		$tblPajamasBrandOfService->contactName = $row['contact_name'];
		$tblPajamasBrandOfService->emailAddress = $row['email_address'];
		$tblPajamasBrandOfService->subject = $row['subject'];
		$tblPajamasBrandOfService->message = $row['message'];
		$tblPajamasBrandOfService->createdAt = $row['created_at'];
		$tblPajamasBrandOfService->updatedAt = $row['updated_at'];

		return $tblPajamasBrandOfService;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblPajamasBrandOfServiceMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>