<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblGroupNameDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblGroupName 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblGroupName primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblGroupName tblGroupName
 	 */
	public function insert($tblGroupName);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblGroupName tblGroupName
 	 */
	public function update($tblGroupName);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGroupName($value);

	public function queryByDateCreated($value);


	public function deleteByGroupName($value);

	public function deleteByDateCreated($value);


}
?>