<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblDprApproveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDprApprove 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDprApprove primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDprApprove tblDprApprove
 	 */
	public function insert($tblDprApprove);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDprApprove tblDprApprove
 	 */
	public function update($tblDprApprove);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByFromDate($value);

	public function queryByToDate($value);

	public function queryByApproveBySuperior($value);

	public function queryByApproveByPartner($value);

	public function queryByDateOfApproval($value);


	public function deleteByUserId($value);

	public function deleteByFromDate($value);

	public function deleteByToDate($value);

	public function deleteByApproveBySuperior($value);

	public function deleteByApproveByPartner($value);

	public function deleteByDateOfApproval($value);


}
?>