<div class="box-standard">
    <div class="row">
        <div class="col-lg-6 col-sm-6">
            <div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> Time Altered Logs</div>
        </div>
    </div>
</div>
<div class="box-standard">
    <form id="formAlteredLogs">
        <div class="row mt-15">
            <div class="row col-lg-8 text-left">
                <div class="col-lg-4">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon input-group-success"><i class="pe-7s-link pe-lg"></i></span>
                            <select class="form-control selectpicker" data-live-search="true" name="domain" required="">
                                
                            </select>
                        </div>
                    </div>
                </div><div class="col-lg-4">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon input-group-success">From:</span>
                            <input id="from" type="text" class="form-control datepicker" name="from"  required="">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-addon input-group-success">To:</span>
                            <input id="to" type="text" class="form-control datepicker" name="to" required="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 text-right">
                <div class="form-group">
                    <div class="col-lg-12">
                        <div class="page-header-buttons-standard-left">
                            <button type="submit" class="btn btn-success btn-pad btnGenerate"><i class="pe-7s-refresh-2 pe-lg"></i> Genarate</button>
                            <button type="button" class="btn btn-success btn-pad btnExport"><i class="pe-7s-download pe-lg"></i> Export</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <div class="row mt-15">
        <div class="col-lg-12 col-sm-12">
            <div class="table-responsive">
                <table class="table table-standard" id="timeAlteredLogs_table">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Domain</th>
                            <th>System Date</th>
                            <th>Altered Date</th>
                            <th>Date Created</th>
                        </tr>
                    </thead>
                    <tbody class="timeAlteredLogsData">
                    </tbody>
                </table>    
            </div>
        </div>
    </div>
</div>

<script>
    $(function(){
        showSubdomains();
        $('#formAlteredLogs').submit(function(){
            tableLoader('#timeAlteredLogs_table');
            var form = $(this).serialize();
            $.post(URL+'dashtito/alteredLogs',form)
            .done(function(returnData){
                if(returnData != '[]'){
                    var data = $.parseJSON(returnData);
                    var append = "";
                    $.each(data,function(key,a){
                        append +=   '<tr>'+
                                        '<td>'+a.name+'</td>'+
                                        '<td>'+a.domain+'</td>'+
                                        '<td>'+a.prev_date+'</td>'+
                                        '<td>'+a.new_date+'</td>'+
                                        '<td>'+a.date_created+'</td>'+
                                    '</tr>';
                    })
                } else {
                    var append = "<tr><td colspan='5' class='text-center'><i class='pe-7s-attention pe-lg'></i> No Results Found</td></tr>";
                }
                $('#timeAlteredLogs_table tbody.timeAlteredLogsData').html(append);
            })
            return false;
        })
    })
    function showSubdomains(){
        $.post(URL+'dashtito/showSubdomainsDT')
        .done(function(returnData){
            var data = $.parseJSON(returnData);
            var append = '<option selected disabled value="">Select Subdomain</option><option value="%%">All</option>';
            $.each(data,function(key,a){
                append += '<option value="'+a.subdomain+'">'+a.username+'</option>';
            })

            $('select[name="domain"]').html(append);
            $('select[name="domain"]').selectpicker('refresh');
        })    
    }
</script>