<?php
/**
 * Class that operate on table 'tbl_tba_per_eng'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblTbaPerEngMySqlDAO implements TblTbaPerEngDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblTbaPerEngMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_tba_per_eng';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_tba_per_eng ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblTbaPerEng primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTbaPerEngMySql tblTbaPerEng
 	 */
	public function insert($tblTbaPerEng){
		$sql = 'INSERT INTO tbl_tba_per_eng (eng_per_dept_id, eng_type_id, tba_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblTbaPerEng->engPerDeptId);
		$sqlQuery->setNumber($tblTbaPerEng->engTypeId);
		$sqlQuery->setNumber($tblTbaPerEng->tbaId);
		$sqlQuery->setNumber($tblTbaPerEng->createdBy);
		$sqlQuery->setNumber($tblTbaPerEng->modifiedBy);
		$sqlQuery->set($tblTbaPerEng->dateCreated);
		$sqlQuery->set($tblTbaPerEng->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblTbaPerEng->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTbaPerEngMySql tblTbaPerEng
 	 */
	public function update($tblTbaPerEng){
		$sql = 'UPDATE tbl_tba_per_eng SET eng_per_dept_id = ?, eng_type_id = ?, tba_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblTbaPerEng->engPerDeptId);
		$sqlQuery->setNumber($tblTbaPerEng->engTypeId);
		$sqlQuery->setNumber($tblTbaPerEng->tbaId);
		$sqlQuery->setNumber($tblTbaPerEng->createdBy);
		$sqlQuery->setNumber($tblTbaPerEng->modifiedBy);
		$sqlQuery->set($tblTbaPerEng->dateCreated);
		$sqlQuery->set($tblTbaPerEng->dateModified);

		$sqlQuery->setNumber($tblTbaPerEng->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_tba_per_eng';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEngPerDeptId($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE eng_per_dept_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngTypeId($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE eng_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTbaId($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE tba_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_tba_per_eng WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEngPerDeptId($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE eng_per_dept_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngTypeId($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE eng_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTbaId($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE tba_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_tba_per_eng WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblTbaPerEngMySql 
	 */
	protected function readRow($row){
		$tblTbaPerEng = new TblTbaPerEng();
		
		$tblTbaPerEng->id = $row['id'];
		$tblTbaPerEng->engPerDeptId = $row['eng_per_dept_id'];
		$tblTbaPerEng->engTypeId = $row['eng_type_id'];
		$tblTbaPerEng->tbaId = $row['tba_id'];
		$tblTbaPerEng->createdBy = $row['created_by'];
		$tblTbaPerEng->modifiedBy = $row['modified_by'];
		$tblTbaPerEng->dateCreated = $row['date_created'];
		$tblTbaPerEng->dateModified = $row['date_modified'];

		return $tblTbaPerEng;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblTbaPerEngMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>