<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblTbaPerEngDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblTbaPerEng 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblTbaPerEng primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTbaPerEng tblTbaPerEng
 	 */
	public function insert($tblTbaPerEng);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTbaPerEng tblTbaPerEng
 	 */
	public function update($tblTbaPerEng);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEngPerDeptId($value);

	public function queryByEngTypeId($value);

	public function queryByTbaId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByEngPerDeptId($value);

	public function deleteByEngTypeId($value);

	public function deleteByTbaId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>