<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblNbtTimeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblNbtTime 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblNbtTime primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtTime tblNbtTime
 	 */
	public function insert($tblNbtTime);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtTime tblNbtTime
 	 */
	public function update($tblNbtTime);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByNbtTimeNo($value);

	public function queryByFrom($value);

	public function queryByTo($value);

	public function queryByDescription($value);

	public function queryByStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByNbtTimeNo($value);

	public function deleteByFrom($value);

	public function deleteByTo($value);

	public function deleteByDescription($value);

	public function deleteByStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>