    <div class="row">
       <div class="col-lg-4 mt-10">
           <div class="panel panel-default">
               <div class="panel-heading">
                   <h3 class="panel-title">Generate location logs</h3>
               </div>
               <div class="panel-body">
                   <form id="generate-form">
                       <p>Kind of transaction: </p>
                       <div class="input-group">

                           <span class="input-group-addon" id="sizing-addon2">
                                <span class="glyphicon glyphicon glyphicon-time" aria-hidden="true"></span>
                           </span>

                           <!-- <input type="email" id="email" required class="form-control" placeholder="E-mail Address" aria-describedby="sizing-addon2"> -->
                          <select class="form-control selectpicker"  required="required" name="type" id="type" data-live-search="true" >
                               <option value="" disabled selected>Select Transaction</option>
                               <option value="in">In</option>
                               <option value="out">Out</option>
                               <option value="between">In Between</option>
                           </select>
                       </div>
                       <br>
                       <p>Employee's List </p>
                       <div class="input-group">
                           <span class="input-group-addon" id="sizing-addon2">
                               <span class="glyphicon glyphicon glyphicon-user" aria-hidden="true"></span>
                           </span>
                          <select class="form-control selectpicker"  name="employee" id="employee" required data-live-search="true">
                           </select>
                       </div>
                       <br>
                       <p>Date:</p>
                       <div class="input-group">
                           <span class="input-group-addon" id="sizing-addon2">
                               <span class="glyphicon glyphicon glyphicon-calendar" aria-hidden="true"></span>
                           </span>
                           <input type="text" required id="dateS" class="form-control datepicker" placeholder="" aria-describedby="sizing-addon2">
                       </div>
                       <br>
                       <div class="input-group col-sm-12 col-lg-12">
                           <input type="submit" class=" btn btn-lg btn-success col-sm-12 col-lg-12 " value="Generate" style="" aria-describedby="sizing-addon2">
                       </div>
                   </form>
               </div>
           </div>
       </div>
       <div class="col-sm-12 col-lg-8 mt-10">
           <div class="panel panel-default">
               <div class="panel-heading">
                   <h3 class="panel-title">Location time is based on device</h3>
               </div>
                <div class="table-responsive">
                    <div id="map" style="width: 740px; height: 430px;"></div>
                </div>
           </div>
       </div>
   </div>




<script>


   var map;
   var j = 0;
   getEmployees();

   function add(){
       var marker = new google.maps.Marker({
           position: new google.maps.LatLng(11.158860,124.990093),
           map: map
       });

       var infowindow = new google.maps.InfoWindow();
       infowindow.setContent("Hello worls");
       infowindow.open(map, marker);

       google.maps.event.addListener(marker, 'click', (function(marker, j) {
           return function() {
               infowindow.setContent("Hello worls");
               infowindow.open(map, marker);
           }
       })(marker, j++));


   }

   function initMap(){

       var locations = [

       ];

       map = new google.maps.Map(document.getElementById('map'), {
           zoom: 1,
           center: new google.maps.LatLng(11.1584, 124.992),
           mapTypeId: google.maps.MapTypeId.ROADMAP
       });


       var infowindow = new google.maps.InfoWindow();
       var marker, i;

       for (i = 0; i < locations.length; i++) {
           marker = new google.maps.Marker({
               position: new google.maps.LatLng(locations[i][1], locations[i][2]),
               map: map
           });

           google.maps.event.addListener(marker, 'click', (function(marker, i) {
               return function() {
                   infowindow.setContent(locations[i][0]);
                   infowindow.open(map, marker);
               }
           })(marker, i));
       }

   }

   function generateMapMarkers(locations){

       var infowindow = new google.maps.InfoWindow();

       var marker, i;

       map = new google.maps.Map(document.getElementById('map'), {
           zoom: 10,
           center: new google.maps.LatLng(locations[0][1], locations[0][2]),
           mapTypeId: google.maps.MapTypeId.ROADMAP
       });

       for (i = 0; i < locations.length; i++) {
           marker = new google.maps.Marker({
               position: new google.maps.LatLng(locations[i][1], locations[i][2]),
               map: map
           });

           google.maps.event.addListener(marker, 'click', (function(marker, i) {
               return function() {
                    infowindow.setContent(locations[i][0]);
                    infowindow.open(map, marker);
               }
           })(marker, i));

       }

   }


   var genform = $('#generate-form');
   $(genform).submit(function(){
       getUserLocLogs();
       return false;
   });


   function getUserLocLogs(){
       var type = $("#type").val();
       var employee = $("#employee").val();
       var dateS = $("#dateS").val();


       $.ajax({
           url : URL+"dashtito/getlogs",
           data : {'type' : type , 'employee': employee , 'dateS' : dateS},
           type : "POST",
           success : function(obj){
                  // console.log(obj);
               if(obj != "empty"){
                   var logs = $.parseJSON(obj);

                   var locations = [];
                   for(var i=0; i < logs.length; i++){
                       var data = [];
                       data[0] = logs[i]["date"];
                       data[1] = logs[i]["latitude"];
                       data[2] = logs[i]["longitude"];
                       data[3] = 1;
                       locations[i] = data;
                   }
                   generateMapMarkers(locations);

               }else{
                  toastr.error('No Result Found');
               }
           }
       });

   }

   function getEmployees(){

       $.post(URL +'dashtito/employees')
       .done(function(returnData){

           data = $.parseJSON(returnData);
           append ='<option value="" disabled selected>Select Employee</option>';

           $.each(data, function(key,a){

               append+= "<option value='"+a.id+"'>"+a.name+"</option>";

           });

           $('#employee').html(append);
           $('#employee').selectpicker('refresh');
       });

   }



</script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCeVydAyXu8mpajX-2F-8h10bZumZ3E9Us&callback=initMap" async defer></script>
