<?php
/**
 * Class that operate on table 'tbl_leave_request'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblLeaveRequestMySqlDAO implements TblLeaveRequestDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveRequestMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_request WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_request';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_request ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveRequest primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_request WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveRequestMySql tblLeaveRequest
 	 */
	public function insert($tblLeaveRequest){
		$sql = 'INSERT INTO tbl_leave_request (subsync_id, subdomain, user_id, approver_id, leave_id, hours_spent, reason, date_requested, approved_date, leave_status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveRequest->subsyncId);
		$sqlQuery->setNumber($tblLeaveRequest->subdomain);
		$sqlQuery->setNumber($tblLeaveRequest->userId);
		$sqlQuery->setNumber($tblLeaveRequest->approverId);
		$sqlQuery->setNumber($tblLeaveRequest->leaveId);
		$sqlQuery->set($tblLeaveRequest->hoursSpent);
		$sqlQuery->set($tblLeaveRequest->reason);
		$sqlQuery->set($tblLeaveRequest->dateRequested);
		$sqlQuery->set($tblLeaveRequest->approvedDate);
		$sqlQuery->set($tblLeaveRequest->leaveStatus);
		$sqlQuery->setNumber($tblLeaveRequest->createdBy);
		$sqlQuery->setNumber($tblLeaveRequest->modifiedBy);
		$sqlQuery->set($tblLeaveRequest->dateCreated);
		$sqlQuery->set($tblLeaveRequest->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeaveRequest->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveRequestMySql tblLeaveRequest
 	 */
	public function update($tblLeaveRequest){
		$sql = 'UPDATE tbl_leave_request SET subsync_id = ?, subdomain = ?, user_id = ?, approver_id = ?, leave_id = ?, hours_spent = ?, reason = ?, date_requested = ?, approved_date = ?, leave_status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveRequest->subsyncId);
		$sqlQuery->setNumber($tblLeaveRequest->subdomain);
		$sqlQuery->setNumber($tblLeaveRequest->userId);
		$sqlQuery->setNumber($tblLeaveRequest->approverId);
		$sqlQuery->setNumber($tblLeaveRequest->leaveId);
		$sqlQuery->set($tblLeaveRequest->hoursSpent);
		$sqlQuery->set($tblLeaveRequest->reason);
		$sqlQuery->set($tblLeaveRequest->dateRequested);
		$sqlQuery->set($tblLeaveRequest->approvedDate);
		$sqlQuery->set($tblLeaveRequest->leaveStatus);
		$sqlQuery->setNumber($tblLeaveRequest->createdBy);
		$sqlQuery->setNumber($tblLeaveRequest->modifiedBy);
		$sqlQuery->set($tblLeaveRequest->dateCreated);
		$sqlQuery->set($tblLeaveRequest->dateModified);

		$sqlQuery->setNumber($tblLeaveRequest->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_request';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproverId($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLeaveId($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE leave_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHoursSpent($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE hours_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReason($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateRequested($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE date_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApprovedDate($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE approved_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLeaveStatus($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE leave_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_leave_request WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproverId($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLeaveId($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE leave_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHoursSpent($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE hours_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReason($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateRequested($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE date_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApprovedDate($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE approved_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLeaveStatus($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE leave_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_leave_request WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveRequestMySql 
	 */
	protected function readRow($row){
		$tblLeaveRequest = new TblLeaveRequest();
		
		$tblLeaveRequest->id = $row['id'];
		$tblLeaveRequest->subsyncId = $row['subsync_id'];
		$tblLeaveRequest->subdomain = $row['subdomain'];
		$tblLeaveRequest->userId = $row['user_id'];
		$tblLeaveRequest->approverId = $row['approver_id'];
		$tblLeaveRequest->leaveId = $row['leave_id'];
		$tblLeaveRequest->hoursSpent = $row['hours_spent'];
		$tblLeaveRequest->reason = $row['reason'];
		$tblLeaveRequest->dateRequested = $row['date_requested'];
		$tblLeaveRequest->approvedDate = $row['approved_date'];
		$tblLeaveRequest->leaveStatus = $row['leave_status'];
		$tblLeaveRequest->createdBy = $row['created_by'];
		$tblLeaveRequest->modifiedBy = $row['modified_by'];
		$tblLeaveRequest->dateCreated = $row['date_created'];
		$tblLeaveRequest->dateModified = $row['date_modified'];

		return $tblLeaveRequest;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveRequestMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>