<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
interface TblScopeOfWorkDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblScopeOfWork 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblScopeOfWork primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblScopeOfWork tblScopeOfWork
 	 */
	public function insert($tblScopeOfWork);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblScopeOfWork tblScopeOfWork
 	 */
	public function update($tblScopeOfWork);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByServiceLineId($value);

	public function queryByScope($value);

	public function queryByDescription($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByServiceLineId($value);

	public function deleteByScope($value);

	public function deleteByDescription($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>