<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblMonthDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblMonth 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblMonth primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblMonth tblMonth
 	 */
	public function insert($tblMonth);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblMonth tblMonth
 	 */
	public function update($tblMonth);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByMonth($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByMonth($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>