<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblNbtHoursSpentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblNbtHoursSpent 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblNbtHoursSpent primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtHoursSpent tblNbtHoursSpent
 	 */
	public function insert($tblNbtHoursSpent);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtHoursSpent tblNbtHoursSpent
 	 */
	public function update($tblNbtHoursSpent);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByNbtTransactionId($value);

	public function queryByDailyForecastId($value);

	public function queryByHoursSpent($value);

	public function queryByHourCode($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByNbtTransactionId($value);

	public function deleteByDailyForecastId($value);

	public function deleteByHoursSpent($value);

	public function deleteByHourCode($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>