<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblEngagementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEngagement 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEngagement primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagement tblEngagement
 	 */
	public function insert($tblEngagement);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagement tblEngagement
 	 */
	public function update($tblEngagement);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEngagementNo($value);

	public function queryByEngagement($value);

	public function queryByType($value);

	public function queryByStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByEngagementNo($value);

	public function deleteByEngagement($value);

	public function deleteByType($value);

	public function deleteByStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>