<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-27 03:54
 */
interface TblClientScheduleDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClientSchedule 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClientSchedule primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientSchedule tblClientSchedule
 	 */
	public function insert($tblClientSchedule);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientSchedule tblClientSchedule
 	 */
	public function update($tblClientSchedule);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByTimeIn($value);

	public function queryByTimeOut($value);

	public function queryBySchedType($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByClientId($value);

	public function deleteByTimeIn($value);

	public function deleteByTimeOut($value);

	public function deleteBySchedType($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>