<?php
/**
 * Class that operate on table 'tbl_time_request'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblTimeRequestMySqlDAO implements TblTimeRequestDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblTimeRequestMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_time_request WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_time_request';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_time_request ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblTimeRequest primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_time_request WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTimeRequestMySql tblTimeRequest
 	 */
	public function insert($tblTimeRequest){
		$sql = 'INSERT INTO tbl_time_request (user_id, approver_id, date_requested, request_type, time_requested, client, location, reason, status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblTimeRequest->userId);
		$sqlQuery->setNumber($tblTimeRequest->approverId);
		$sqlQuery->set($tblTimeRequest->dateRequested);
		$sqlQuery->set($tblTimeRequest->requestType);
		$sqlQuery->set($tblTimeRequest->timeRequested);
		$sqlQuery->set($tblTimeRequest->client);
		$sqlQuery->set($tblTimeRequest->location);
		$sqlQuery->set($tblTimeRequest->reason);
		$sqlQuery->set($tblTimeRequest->status);
		$sqlQuery->setNumber($tblTimeRequest->createdBy);
		$sqlQuery->setNumber($tblTimeRequest->modifiedBy);
		$sqlQuery->set($tblTimeRequest->dateCreated);
		$sqlQuery->set($tblTimeRequest->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblTimeRequest->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTimeRequestMySql tblTimeRequest
 	 */
	public function update($tblTimeRequest){
		$sql = 'UPDATE tbl_time_request SET user_id = ?, approver_id = ?, date_requested = ?, request_type = ?, time_requested = ?, client = ?, location = ?, reason = ?, status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblTimeRequest->userId);
		$sqlQuery->setNumber($tblTimeRequest->approverId);
		$sqlQuery->set($tblTimeRequest->dateRequested);
		$sqlQuery->set($tblTimeRequest->requestType);
		$sqlQuery->set($tblTimeRequest->timeRequested);
		$sqlQuery->set($tblTimeRequest->client);
		$sqlQuery->set($tblTimeRequest->location);
		$sqlQuery->set($tblTimeRequest->reason);
		$sqlQuery->set($tblTimeRequest->status);
		$sqlQuery->setNumber($tblTimeRequest->createdBy);
		$sqlQuery->setNumber($tblTimeRequest->modifiedBy);
		$sqlQuery->set($tblTimeRequest->dateCreated);
		$sqlQuery->set($tblTimeRequest->dateModified);

		$sqlQuery->setNumber($tblTimeRequest->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_time_request';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproverId($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateRequested($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE date_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRequestType($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE request_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeRequested($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE time_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLocation($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE location = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReason($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_time_request WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_time_request WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproverId($value){
		$sql = 'DELETE FROM tbl_time_request WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateRequested($value){
		$sql = 'DELETE FROM tbl_time_request WHERE date_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRequestType($value){
		$sql = 'DELETE FROM tbl_time_request WHERE request_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeRequested($value){
		$sql = 'DELETE FROM tbl_time_request WHERE time_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM tbl_time_request WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLocation($value){
		$sql = 'DELETE FROM tbl_time_request WHERE location = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReason($value){
		$sql = 'DELETE FROM tbl_time_request WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_time_request WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_time_request WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_time_request WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_time_request WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_time_request WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblTimeRequestMySql 
	 */
	protected function readRow($row){
		$tblTimeRequest = new TblTimeRequest();
		
		$tblTimeRequest->id = $row['id'];
		$tblTimeRequest->userId = $row['user_id'];
		$tblTimeRequest->approverId = $row['approver_id'];
		$tblTimeRequest->dateRequested = $row['date_requested'];
		$tblTimeRequest->requestType = $row['request_type'];
		$tblTimeRequest->timeRequested = $row['time_requested'];
		$tblTimeRequest->client = $row['client'];
		$tblTimeRequest->location = $row['location'];
		$tblTimeRequest->reason = $row['reason'];
		$tblTimeRequest->status = $row['status'];
		$tblTimeRequest->createdBy = $row['created_by'];
		$tblTimeRequest->modifiedBy = $row['modified_by'];
		$tblTimeRequest->dateCreated = $row['date_created'];
		$tblTimeRequest->dateModified = $row['date_modified'];

		return $tblTimeRequest;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblTimeRequestMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>