<?php
/**
 * Class that operate on table 'tbl_project_budget'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblProjectBudgetMySqlDAO implements TblProjectBudgetDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblProjectBudgetMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_project_budget WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_project_budget';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_project_budget ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblProjectBudget primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_project_budget WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblProjectBudgetMySql tblProjectBudget
 	 */
	public function insert($tblProjectBudget){
		$sql = 'INSERT INTO tbl_project_budget (project_id, act_id, position, budget_hours, additional_budget) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblProjectBudget->projectId);
		$sqlQuery->setNumber($tblProjectBudget->actId);
		$sqlQuery->set($tblProjectBudget->position);
		$sqlQuery->setNumber($tblProjectBudget->budgetHours);
		$sqlQuery->setNumber($tblProjectBudget->additionalBudget);

		$id = $this->executeInsert($sqlQuery);	
		$tblProjectBudget->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblProjectBudgetMySql tblProjectBudget
 	 */
	public function update($tblProjectBudget){
		$sql = 'UPDATE tbl_project_budget SET project_id = ?, act_id = ?, position = ?, budget_hours = ?, additional_budget = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblProjectBudget->projectId);
		$sqlQuery->setNumber($tblProjectBudget->actId);
		$sqlQuery->set($tblProjectBudget->position);
		$sqlQuery->setNumber($tblProjectBudget->budgetHours);
		$sqlQuery->setNumber($tblProjectBudget->additionalBudget);

		$sqlQuery->setNumber($tblProjectBudget->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_project_budget';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProjectId($value){
		$sql = 'SELECT * FROM tbl_project_budget WHERE project_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActId($value){
		$sql = 'SELECT * FROM tbl_project_budget WHERE act_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPosition($value){
		$sql = 'SELECT * FROM tbl_project_budget WHERE position = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBudgetHours($value){
		$sql = 'SELECT * FROM tbl_project_budget WHERE budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAdditionalBudget($value){
		$sql = 'SELECT * FROM tbl_project_budget WHERE additional_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProjectId($value){
		$sql = 'DELETE FROM tbl_project_budget WHERE project_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActId($value){
		$sql = 'DELETE FROM tbl_project_budget WHERE act_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPosition($value){
		$sql = 'DELETE FROM tbl_project_budget WHERE position = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBudgetHours($value){
		$sql = 'DELETE FROM tbl_project_budget WHERE budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAdditionalBudget($value){
		$sql = 'DELETE FROM tbl_project_budget WHERE additional_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblProjectBudgetMySql 
	 */
	protected function readRow($row){
		$tblProjectBudget = new TblProjectBudget();
		
		$tblProjectBudget->id = $row['id'];
		$tblProjectBudget->projectId = $row['project_id'];
		$tblProjectBudget->actId = $row['act_id'];
		$tblProjectBudget->position = $row['position'];
		$tblProjectBudget->budgetHours = $row['budget_hours'];
		$tblProjectBudget->additionalBudget = $row['additional_budget'];

		return $tblProjectBudget;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblProjectBudgetMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>