<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblUserGroupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserGroup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserGroup primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserGroup tblUserGroup
 	 */
	public function insert($tblUserGroup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserGroup tblUserGroup
 	 */
	public function update($tblUserGroup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGrpId($value);

	public function queryByName($value);

	public function queryByStatus($value);


	public function deleteByGrpId($value);

	public function deleteByName($value);

	public function deleteByStatus($value);


}
?>