<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblReportSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblReportSetup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblReportSetup primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblReportSetup tblReportSetup
 	 */
	public function insert($tblReportSetup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblReportSetup tblReportSetup
 	 */
	public function update($tblReportSetup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReport($value);

	public function queryByTime($value);

	public function queryByFrequency($value);

	public function queryByDeadlineWeek($value);

	public function queryByDeadlineDay($value);

	public function queryByCutoffTime($value);

	public function queryByCutoffDay($value);

	public function queryByExtensionTime($value);

	public function queryByExtensionDay($value);


	public function deleteByReport($value);

	public function deleteByTime($value);

	public function deleteByFrequency($value);

	public function deleteByDeadlineWeek($value);

	public function deleteByDeadlineDay($value);

	public function deleteByCutoffTime($value);

	public function deleteByCutoffDay($value);

	public function deleteByExtensionTime($value);

	public function deleteByExtensionDay($value);


}
?>