<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblClientSchedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClientSched 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClientSched primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientSched tblClientSched
 	 */
	public function insert($tblClientSched);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientSched tblClientSched
 	 */
	public function update($tblClientSched);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByDescription($value);

	public function queryByTimeIn($value);

	public function queryByTimeOut($value);

	public function queryByStatus($value);


	public function deleteByName($value);

	public function deleteByDescription($value);

	public function deleteByTimeIn($value);

	public function deleteByTimeOut($value);

	public function deleteByStatus($value);


}
?>