<?php
/**
 * Class that operate on table 'tbl_subdomain_per_dept'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblSubdomainPerDeptMySqlDAO implements TblSubdomainPerDeptDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblSubdomainPerDeptMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblSubdomainPerDept primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSubdomainPerDeptMySql tblSubdomainPerDept
 	 */
	public function insert($tblSubdomainPerDept){
		$sql = 'INSERT INTO tbl_subdomain_per_dept (subdomain_id, department_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSubdomainPerDept->subdomainId);
		$sqlQuery->setNumber($tblSubdomainPerDept->departmentId);
		$sqlQuery->setNumber($tblSubdomainPerDept->createdBy);
		$sqlQuery->setNumber($tblSubdomainPerDept->modifiedBy);
		$sqlQuery->set($tblSubdomainPerDept->dateCreated);
		$sqlQuery->set($tblSubdomainPerDept->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblSubdomainPerDept->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSubdomainPerDeptMySql tblSubdomainPerDept
 	 */
	public function update($tblSubdomainPerDept){
		$sql = 'UPDATE tbl_subdomain_per_dept SET subdomain_id = ?, department_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSubdomainPerDept->subdomainId);
		$sqlQuery->setNumber($tblSubdomainPerDept->departmentId);
		$sqlQuery->setNumber($tblSubdomainPerDept->createdBy);
		$sqlQuery->setNumber($tblSubdomainPerDept->modifiedBy);
		$sqlQuery->set($tblSubdomainPerDept->dateCreated);
		$sqlQuery->set($tblSubdomainPerDept->dateModified);

		$sqlQuery->setNumber($tblSubdomainPerDept->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_subdomain_per_dept';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubdomainId($value){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE subdomain_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartmentId($value){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE department_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_subdomain_per_dept WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubdomainId($value){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE subdomain_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartmentId($value){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE department_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_subdomain_per_dept WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblSubdomainPerDeptMySql 
	 */
	protected function readRow($row){
		$tblSubdomainPerDept = new TblSubdomainPerDept();
		
		$tblSubdomainPerDept->id = $row['id'];
		$tblSubdomainPerDept->subdomainId = $row['subdomain_id'];
		$tblSubdomainPerDept->departmentId = $row['department_id'];
		$tblSubdomainPerDept->createdBy = $row['created_by'];
		$tblSubdomainPerDept->modifiedBy = $row['modified_by'];
		$tblSubdomainPerDept->dateCreated = $row['date_created'];
		$tblSubdomainPerDept->dateModified = $row['date_modified'];

		return $tblSubdomainPerDept;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblSubdomainPerDeptMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>