<?php
/**
 * Class that operate on table 'tbl_leave_credits_per_type'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblLeaveCreditsPerTypeMySqlDAO implements TblLeaveCreditsPerTypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveCreditsPerTypeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCreditsPerType primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCreditsPerTypeMySql tblLeaveCreditsPerType
 	 */
	public function insert($tblLeaveCreditsPerType){
		$sql = 'INSERT INTO tbl_leave_credits_per_type (leave_credits_id, leave_per_type_id, credits, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCreditsPerType->leaveCreditsId);
		$sqlQuery->setNumber($tblLeaveCreditsPerType->leavePerTypeId);
		$sqlQuery->set($tblLeaveCreditsPerType->credits);
		$sqlQuery->setNumber($tblLeaveCreditsPerType->createdBy);
		$sqlQuery->setNumber($tblLeaveCreditsPerType->modifiedBy);
		$sqlQuery->set($tblLeaveCreditsPerType->dateCreated);
		$sqlQuery->set($tblLeaveCreditsPerType->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeaveCreditsPerType->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCreditsPerTypeMySql tblLeaveCreditsPerType
 	 */
	public function update($tblLeaveCreditsPerType){
		$sql = 'UPDATE tbl_leave_credits_per_type SET leave_credits_id = ?, leave_per_type_id = ?, credits = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCreditsPerType->leaveCreditsId);
		$sqlQuery->setNumber($tblLeaveCreditsPerType->leavePerTypeId);
		$sqlQuery->set($tblLeaveCreditsPerType->credits);
		$sqlQuery->setNumber($tblLeaveCreditsPerType->createdBy);
		$sqlQuery->setNumber($tblLeaveCreditsPerType->modifiedBy);
		$sqlQuery->set($tblLeaveCreditsPerType->dateCreated);
		$sqlQuery->set($tblLeaveCreditsPerType->dateModified);

		$sqlQuery->setNumber($tblLeaveCreditsPerType->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_credits_per_type';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByLeaveCreditsId($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE leave_credits_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLeavePerTypeId($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE leave_per_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_leave_credits_per_type WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByLeaveCreditsId($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE leave_credits_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLeavePerTypeId($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE leave_per_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_leave_credits_per_type WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveCreditsPerTypeMySql 
	 */
	protected function readRow($row){
		$tblLeaveCreditsPerType = new TblLeaveCreditsPerType();
		
		$tblLeaveCreditsPerType->id = $row['id'];
		$tblLeaveCreditsPerType->leaveCreditsId = $row['leave_credits_id'];
		$tblLeaveCreditsPerType->leavePerTypeId = $row['leave_per_type_id'];
		$tblLeaveCreditsPerType->credits = $row['credits'];
		$tblLeaveCreditsPerType->createdBy = $row['created_by'];
		$tblLeaveCreditsPerType->modifiedBy = $row['modified_by'];
		$tblLeaveCreditsPerType->dateCreated = $row['date_created'];
		$tblLeaveCreditsPerType->dateModified = $row['date_modified'];

		return $tblLeaveCreditsPerType;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveCreditsPerTypeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>