<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-04-11 08:51
 */
interface TblLeaveCreditsPerTypeTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblLeaveCreditsPerTypeTransaction 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCreditsPerTypeTransaction primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCreditsPerTypeTransaction tblLeaveCreditsPerTypeTransaction
 	 */
	public function insert($tblLeaveCreditsPerTypeTransaction);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCreditsPerTypeTransaction tblLeaveCreditsPerTypeTransaction
 	 */
	public function update($tblLeaveCreditsPerTypeTransaction);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByLeaveCreditsPerTypeId($value);

	public function queryByOldCredits($value);

	public function queryByNewCredits($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByLeaveCreditsPerTypeId($value);

	public function deleteByOldCredits($value);

	public function deleteByNewCredits($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>