<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblLeaveCreditsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblLeaveCredits 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCredit primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCredits tblLeaveCredit
 	 */
	public function insert($tblLeaveCredit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCredits tblLeaveCredit
 	 */
	public function update($tblLeaveCredit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByCode($value);

	public function queryBySL($value);

	public function queryByVL($value);

	public function queryBySIL($value);

	public function queryByTotalCredits($value);


	public function deleteByUserId($value);

	public function deleteByCode($value);

	public function deleteBySL($value);

	public function deleteByVL($value);

	public function deleteBySIL($value);

	public function deleteByTotalCredits($value);


}
?>