<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblGroupActivityDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblGroupActivity 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblGroupActivity primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblGroupActivity tblGroupActivity
 	 */
	public function insert($tblGroupActivity);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblGroupActivity tblGroupActivity
 	 */
	public function update($tblGroupActivity);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGroupId($value);

	public function queryByDescription($value);

	public function queryByStatus($value);


	public function deleteByGroupId($value);

	public function deleteByDescription($value);

	public function deleteByStatus($value);


}
?>