<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblClientProjectDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClientProject 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClientProject primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientProject tblClientProject
 	 */
	public function insert($tblClientProject);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientProject tblClientProject
 	 */
	public function update($tblClientProject);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByProjectId($value);

	public function queryByProjectname($value);

	public function queryByCostCenter($value);

	public function queryByDepartment($value);

	public function queryByGrpId($value);

	public function queryByType($value);

	public function queryByStatus($value);

	public function queryByManagedBy($value);

	public function queryByDateStart($value);

	public function queryByEstimatedEnd($value);

	public function queryByBudgetHrs($value);

	public function queryByReferredBy($value);

	public function queryByInitiatedBy($value);

	public function queryByClosedBy($value);

	public function queryByClClient($value);

	public function queryByReferredType($value);

	public function queryByAdditionalBudget($value);

	public function queryByPartnerBudget($value);

	public function queryByManagerBudget($value);

	public function queryBySnrManagerBudget($value);

	public function queryByJrManagerBudget($value);

	public function queryBySupervisorBudget($value);

	public function queryBySeniorBudget($value);

	public function queryByStaffBudget($value);

	public function queryByContractPrice($value);

	public function queryByEngagementType($value);


	public function deleteByClientId($value);

	public function deleteByProjectId($value);

	public function deleteByProjectname($value);

	public function deleteByCostCenter($value);

	public function deleteByDepartment($value);

	public function deleteByGrpId($value);

	public function deleteByType($value);

	public function deleteByStatus($value);

	public function deleteByManagedBy($value);

	public function deleteByDateStart($value);

	public function deleteByEstimatedEnd($value);

	public function deleteByBudgetHrs($value);

	public function deleteByReferredBy($value);

	public function deleteByInitiatedBy($value);

	public function deleteByClosedBy($value);

	public function deleteByClClient($value);

	public function deleteByReferredType($value);

	public function deleteByAdditionalBudget($value);

	public function deleteByPartnerBudget($value);

	public function deleteByManagerBudget($value);

	public function deleteBySnrManagerBudget($value);

	public function deleteByJrManagerBudget($value);

	public function deleteBySupervisorBudget($value);

	public function deleteBySeniorBudget($value);

	public function deleteByStaffBudget($value);

	public function deleteByContractPrice($value);

	public function deleteByEngagementType($value);


}
?>