<div class="box-standard">
	<div class="row">
		<div class="col-lg-6 col-sm-6">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> DAR Report</div>
		</div>
	</div>
</div>
<div class="box-standard">
	<form id="generateDar">
		<div class="row mt-15">
			<div class="col-lg-12">
				<div class="col-lg-6 text-left">
						<div class="form-group">
							<div class="input-group">
							    <span class="input-group-addon input-group-success"><i class="pe-7s-link pe-lg"></i></span>
							    <select class="form-control selectpicker" data-live-search="true" name="subdomain" required>
							    	
							    </select>
							</div>
						</div>
				</div>
				<div class="col-lg-6 text-right">
					<div class="form-group">
						<div class="input-group">
						    <span class="input-group-addon input-group-success">Type:</span>
						    <select class="form-control selectpicker" data-live-search="true" name="status" required>
						    	<option value="%%">All</option>
						    	<option value="%approved%">Approved</option>
								<option value="%pending%">Disapproved</option>
						    </select>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-15">
			<div class="col-lg-8 text-left">
				<div class="col-lg-6">
					<div class="form-group">
						<div class="input-group">
						    <span class="input-group-addon input-group-success">From:</span>
						    <input id="from" type="text" class="form-control datepicker" value="<?= isset($_REQUEST['from']) ? $_REQUEST['from'] : ''?>" name="from" required>
						</div>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="form-group">
						<div class="input-group">
						    <span class="input-group-addon input-group-success">To:</span>
						    <input id="to" type="text" class="form-control datepicker" value="<?= isset($_REQUEST['to']) ? $_REQUEST['to'] : ''?>" name="to" required>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-4 text-right">
				<div class="form-group">
					<div class="col-lg-12">
						<div class="page-header-buttons-standard-left">
							<button class="btn btn-success btn-pad" type="submit"><i class="pe-7s-refresh-2 pe-lg"></i> Genarate</button>
							<button class="btn btn-success btn-pad btnExport" type="button"><i class="pe-7s-download pe-lg"></i> Export</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</form>
	<div class="row mt-10">
		<div class="col-lg-12">
			<div class="col-lg-12">
				<div class="col-lg-6" style="padding: 0;">
					<div class="wrap">
						<div class="table-responsive">
							<table class="table table-striped table-standard table-bordered" id="user_pane">
								<thead>
									<tr style="height: 62px" class="tr-top">
										<th rowspan="3"></th>
										<th rowspan="3">Surname</th>
										<th rowspan="3">Given Name</th>
										<th rowspan="3">Date Hired</th>
									</tr>
									<tr>
										<!-- <th></th>
										<th></th>
										<th></th>
										<th></th> -->
									</tr>
									<tr style="height:76px;">
										
									</tr>
								</thead>
								<tbody class="userpane">
								</tbody>
							</table>
						</div>
					</div>
				</div>
				<div class="col-lg-6" style="padding: 0;">
					<div class="wrap">
						<div class="table-responsive">
							<table class="table table-striped table-standard table-bordered" id="dar_report">
								<thead>
									<tr>
										<th>Regular Hours</th>
										<th>Regular Overtime</th>
										<th>Legal Holiday (Non working)</th>
										<th>Legal Holiday (Working)</th>
										<th>Legal Holiday in Excess of 8 hours</th>
										<th>Legal Holiday/Restday</th>
										<th>Legal Holiday/Restday in Excess of 8 hours</th>
										<th>OT Hours with Night Differential</th>
										<th>Night Shift Differential</th>
										<th>Special Holiday (Non working)</th>
										<th>Special Holiday OT</th>
										<th>Special Holiday OT in excess of 8 hours</th>
										<th>Special Holiday/Restday in Excess of 8 hours</th>
										<th>Sunday/Restday</th>
										<th>Sunday/Restday(Excess)</th>
										<th>Night Differential - Special Holiday</th>
										<th>Night Differential - Legal Holiday</th>
										<th>LATE(hrs)</th>
										<th>UT(hrs)</th>
										<th>Absent(hrs)</th>
										<th>VL(days)</th>
										<th>SL(days)</th>		
										<th>SIL(days)</th>		
										<th>Reimbursement</th>		
									</tr>
								</thead>
								<tbody class="report">
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
$(function(){
	var from = "<?= isset($_REQUEST['from']) ? $_REQUEST['from'] : ''?>"; 
	var to = "<?= isset($_REQUEST['to']) ? $_REQUEST['to'] : ''?>";
	var subdomain = "<?= isset($_REQUEST['subdomain']) ? $_REQUEST['subdomain'] : 'none'?>";
		getSubdomain(subdomain);
	if(subdomain!='none'){
		generateDar(from,to,subdomain);
	}
	
	$('.btnExport').click(function(){
		subdomain = $("select[name='subdomain']").val();
		status = $("select[name='status']").val();
		from = $('input[name="from"]').val();
		to = $('input[name="to"]').val();
		window.location = URL +"export/dar?subdomain="+subdomain+"&status="+status+"&from="+from+"&to="+to;
	})

	$('#generateDar').submit(function(){
		tableLoader('#user_pane');
		tableLoader('#dar_report');
		from = $('input[name="from"]').val();
		to = $('input[name="to"]').val();
		subdomain = $("select[name='subdomain']").val();
		var form = $(this).serialize();
		$.post(URL+'reports/darReport', form)
		.done(function(returnData){
			if(returnData != '[]'){
				var data = $.parseJSON(returnData);
				var userPane = '';
				var darReport = '';
				$.each(data, function(x,i){
					color  = i.approve_status == 'approved' ? 'text-info' : 'text-danger';
					userPane += '<tr>'+
									'<td class="text-center">'+
										'<a href="'+URL+'reports/dprList?from='+from+'&to='+to+'&subdomain='+subdomain+'&userId='+i.user_id+'" <span class="text-info"><i class="fa fa-folder-open-o"></i></span></a>&nbsp'+
										'<span class="'+color+'"><i class="fa fa-thumbs-up"></i></span>'+
									'</td>'+
									'<td>'+i.lname+'</td>'+
									'<td>'+i.given_name+'</td>'+
									'<td>'+i.date_hired+'</td>'+
								'</tr>';

					darReport += '<tr>'+
									'<td>'+i.RT+'</td>'+
									'<td>'+i.ROT+'</td>'+
									'<td>0</td>'+
									'<td>'+i.LH+'</td>'+
									'<td>'+i.LHE+'</td>'+
									'<td>0</td>'+
									'<td>0</td>'+
									'<td>'+i.NDOT+'</td>'+
									'<td>'+i.NSD+'</td>'+
									'<td>0</td>'+
									'<td>'+i.SH+'</td>'+
									'<td>'+i.SHE+'</td>'+
									'<td>0</td>'+
									'<td>'+i.SOT+'</td>'+
									'<td>'+i.SOTE+'</td>'+
									'<td>0</td>'+
									'<td>0</td>'+
									'<td>'+i.LATE+'</td>'+
									'<td>'+i.UT+'</td>'+
									'<td>'+i.AL+'</td>'+
									'<td>'+i.VL+'</td>'+
									'<td>'+i.SL+'</td>'+
									'<td>'+i.SIL+'</td>'+
									'<td>'+i.reimbursement+'</td>'+
								'</tr>';
 				})
			} else {
				userPane += '<tr>'+
								'<td colspan="4" class="text-center">'+
									'No Results Found'+
								'</td>'+
							'</tr>';

				darReport += '<tr>'+
								'<td colspan="38" class="text-center">No Results Found</td>'+
							'</tr>';
			}
				$('#user_pane').find('tbody.userpane').html(userPane);
				$('#dar_report').find('tbody.report').html(darReport);
		})
		return false;
	})
})
function getSubdomain(subdomain){
	$.post(URL + 'employee/showSubdomains')
	.done(function(returnData){
		var data = $.parseJSON(returnData);

		var append = '';
		$.each(data,function(key,a){
			selected = (subdomain == a.id) ? 'selected' :'';
			append +=  '<option value="'+a.id+'" '+selected+'>'+a.subdomain+'</option>';
		})
		$('#generateDar').find('select[name=subdomain]').html(append);
		$('#generateDar').find('select[name=subdomain]').selectpicker('refresh');
	})
}
function generateDar(from,to,subdomain,status = '%%'){
	tableLoader('#user_pane');
		tableLoader('#dar_report');
	$.post(URL+'reports/darReport', {'from':from,'to':to,'subdomain':subdomain,'status':status})
	.done(function(returnData){
		if(returnData != '[]'){
			var data = $.parseJSON(returnData);
			var userPane = '';
			var darReport = '';
			$.each(data, function(x,i){
				color  = i.approve_status == 'approved' ? 'text-info' : 'text-danger';
				userPane += '<tr>'+
								'<td class="text-center">'+
									'<a href="'+URL+'reports/dprList?from='+from+'&to='+to+'&subdomain='+subdomain+'&userId='+i.user_id+'" <span class="text-info"><i class="fa fa-folder-open-o"></i></span></a>&nbsp'+
									'<span class="'+color+'"><i class="fa fa-thumbs-up"></i></span>'+
								'</td>'+
								'<td>'+i.lname+'</td>'+
								'<td>'+i.given_name+'</td>'+
								'<td>'+i.date_hired+'</td>'+
							'</tr>';

				darReport += '<tr>'+
								'<td>'+i.RT+'</td>'+
								'<td>'+i.ROT+'</td>'+
								'<td>0</td>'+
								'<td>'+i.LH+'</td>'+
								'<td>'+i.LHE+'</td>'+
								'<td>0</td>'+
								'<td>0</td>'+
								'<td>'+i.NDOT+'</td>'+
								'<td>'+i.NSD+'</td>'+
								'<td>0</td>'+
								'<td>'+i.SH+'</td>'+
								'<td>'+i.SHE+'</td>'+
								'<td>0</td>'+
								'<td>'+i.SOT+'</td>'+
								'<td>'+i.SOTE+'</td>'+
								'<td>0</td>'+
								'<td>0</td>'+
								'<td>'+i.LATE+'</td>'+
								'<td>'+i.UT+'</td>'+
								'<td>'+i.AL+'</td>'+
								'<td>'+i.VL+'</td>'+
								'<td>'+i.SL+'</td>'+
								'<td>'+i.SIL+'</td>'+
								'<td>'+i.reimbursement+'</td>'+
							'</tr>';
			})
		} else {
			userPane += '<tr>'+
							'<td colspan="4" class="text-center">'+
								'No Results Found'+
							'</td>'+
						'</tr>';

			darReport += '<tr>'+
							'<td colspan="38" class="text-center">No Results Found</td>'+
						'</tr>';
		}
			$('#user_pane').find('tbody.userpane').html(userPane);
			$('#dar_report').find('tbody.report').html(darReport);
	})
	return false;
}
</script>