<?php 
	$position = DAOFactory::getTblPositionDAO()->queryAll();
	$engType = DAOFactory::getTblEngagementTypeDAO()->queryAll();
?>
<form method="post" id="accessForm">
<div class="box-standard">
	<div class="row">
		<div class="col-lg-6 col-sm-6">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> Engagement Access</div>
		</div>
		<div class="col-lg-6 col-sm-6 text-right">
			<span id="departmentName" style="font-weight: bolder; padding-right: 10px;"></span>
			<button type="button" class="btn btn-success sample"><i class="pe-7s-search pe-lg"></i> Select</button>
			<button type="submit" class="btn btn-success"><i class="pe-7s-paper-plane pe-lg"></i> Save</button>
		</div>
	</div>
</div>
<div class="box-standard">
	<div class="row">
		<div class="col-lg-12">
				<div class="wrap">
					<div class="table-responsive">
						<input type="hidden" name="department_id">
						<table class="table table-standard">
							<thead>
								<tr>
									<th></th>
									<th>Engagement Type</th>
									<?php foreach ($position as $each): ?>	
										<th><?= $each->position ?></th>
									<?php endforeach;?>
								</tr>
							</thead>
							<tbody class="returnGenerate">
							</tbody>
						</table>
					</div>
				</div>
		</div>
	</div>
</div>
</form>
<form method="post" id="formGenerateMapEngagement">
	
	<div id="sampleModal" class="modal fade" role="dialog">
		<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"><i class="pe-7s-search pe-lg"></i> Select</h4>
			</div>
			<div class="modal-body">
				<div class="form-group">
					Department: <select type="text" name="department" data-live-search="true" class="form-control selectpicker" required=""></select>
				</div>
			</div>
			<div class="modal-footer">
				<button type="submit" id="btnSave" class="btn btn-success btn-block">Generate</button>
			</div>
		</div>

		</div>
	</div>
</form>
<script>
	$(function(){
		$('.sample').click(function(){
			 getDepartment()
			$('#sampleModal').modal({
			  	backdrop: 'static', 
			    keyboard: false,
			    toggle: true
			 });
		})
		$('#formGenerateMapEngagement').submit(function(){
			var department = $(this).find('select[name="department"]').val();
			var departmentName = $(this).find('select[name="department"] option:selected').attr('deptname');
			$('input[name="department_id"]').val(department);
			$('#departmentName').html(departmentName);
			var form = $(this).serialize();
			$.post(URL+'access/generateEngAccess',form)
			.done(function(returnData){
				$('.returnGenerate').html(returnData);
				$('#sampleModal').modal('toggle');
			});
			return false;
		})
		$('#accessForm').submit(function(){
			var form = $(this).serialize();
			$.post(URL+'access/saveEngAccess',form)
			.done(function(returnData){
				toastr.success('Saved Successfully');
				setTimeout(function(){
					location.reload();
				}, 2500)
			});
			return false;
		})
	})
	function getDepartment(){
		$.post(URL+'setup/showDepartment')
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '<option selected disabled></option>';
			$.each(data,function(key,a){
				append += '<option value="'+a.id+'" deptname="'+a.deptNo+' - '+a.department+'">'+a.deptNo+' - '+a.department+'</option>';
			})
			$('#formGenerateMapEngagement').find('select[name="department"]').html(append);
			$('#formGenerateMapEngagement').find('select[name="department"]').selectpicker('refresh');
		})
	}
</script>