<?php
/**
 * Class that operate on table 'tbl_rate_per_position'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-01-16 03:29
 */
class TblRatePerPositionMySqlDAO implements TblRatePerPositionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblRatePerPositionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_rate_per_position';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_rate_per_position ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblRatePerPosition primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRatePerPositionMySql tblRatePerPosition
 	 */
	public function insert($tblRatePerPosition){
		$sql = 'INSERT INTO tbl_rate_per_position (subdomain, position_id, rate, type, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblRatePerPosition->subdomain);
		$sqlQuery->setNumber($tblRatePerPosition->positionId);
		$sqlQuery->set($tblRatePerPosition->rate);
		$sqlQuery->set($tblRatePerPosition->type);
		$sqlQuery->setNumber($tblRatePerPosition->createdBy);
		$sqlQuery->setNumber($tblRatePerPosition->modifiedBy);
		$sqlQuery->set($tblRatePerPosition->dateCreated);
		$sqlQuery->set($tblRatePerPosition->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblRatePerPosition->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRatePerPositionMySql tblRatePerPosition
 	 */
	public function update($tblRatePerPosition){
		$sql = 'UPDATE tbl_rate_per_position SET subdomain = ?, position_id = ?, rate = ?, type = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblRatePerPosition->subdomain);
		$sqlQuery->setNumber($tblRatePerPosition->positionId);
		$sqlQuery->set($tblRatePerPosition->rate);
		$sqlQuery->set($tblRatePerPosition->type);
		$sqlQuery->setNumber($tblRatePerPosition->createdBy);
		$sqlQuery->setNumber($tblRatePerPosition->modifiedBy);
		$sqlQuery->set($tblRatePerPosition->dateCreated);
		$sqlQuery->set($tblRatePerPosition->dateModified);

		$sqlQuery->setNumber($tblRatePerPosition->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_rate_per_position';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPositionId($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRate($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE rate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByType($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_rate_per_position WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPositionId($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRate($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE rate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByType($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_rate_per_position WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblRatePerPositionMySql 
	 */
	protected function readRow($row){
		$tblRatePerPosition = new TblRatePerPosition();
		
		$tblRatePerPosition->id = $row['id'];
		$tblRatePerPosition->subdomain = $row['subdomain'];
		$tblRatePerPosition->positionId = $row['position_id'];
		$tblRatePerPosition->rate = $row['rate'];
		$tblRatePerPosition->type = $row['type'];
		$tblRatePerPosition->createdBy = $row['created_by'];
		$tblRatePerPosition->modifiedBy = $row['modified_by'];
		$tblRatePerPosition->dateCreated = $row['date_created'];
		$tblRatePerPosition->dateModified = $row['date_modified'];

		return $tblRatePerPosition;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblRatePerPositionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>