<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblAttendanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblAttendance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblAttendance primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblAttendance tblAttendance
 	 */
	public function insert($tblAttendance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblAttendance tblAttendance
 	 */
	public function update($tblAttendance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByUserId($value);

	public function queryByTime($value);

	public function queryByType($value);

	public function queryByLocation($value);

	public function queryByClient($value);

	public function queryBySyncedDate($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByUserId($value);

	public function deleteByTime($value);

	public function deleteByType($value);

	public function deleteByLocation($value);

	public function deleteByClient($value);

	public function deleteBySyncedDate($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>