<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblPlanRecordsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPlanRecords 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPlanRecord primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPlanRecords tblPlanRecord
 	 */
	public function insert($tblPlanRecord);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPlanRecords tblPlanRecord
 	 */
	public function update($tblPlanRecord);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTransId($value);

	public function queryByLine($value);

	public function queryByTransaction($value);

	public function queryByActivity($value);

	public function queryByPlanOutput($value);

	public function queryByBudgetHours($value);

	public function queryByRemainingBudget($value);

	public function queryByHoursCode($value);

	public function queryByDeadline($value);

	public function queryBySuperiorId($value);


	public function deleteByTransId($value);

	public function deleteByLine($value);

	public function deleteByTransaction($value);

	public function deleteByActivity($value);

	public function deleteByPlanOutput($value);

	public function deleteByBudgetHours($value);

	public function deleteByRemainingBudget($value);

	public function deleteByHoursCode($value);

	public function deleteByDeadline($value);

	public function deleteBySuperiorId($value);


}
?>