<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-03-21 01:40
 */
interface TblLogsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblLogs 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblLog primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLogs tblLog
 	 */
	public function insert($tblLog);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLogs tblLog
 	 */
	public function update($tblLog);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByType($value);

	public function queryByLog($value);

	public function queryByDateTime($value);


	public function deleteByType($value);

	public function deleteByLog($value);

	public function deleteByDateTime($value);


}
?>