<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-01 09:20
 */
interface TblUpdateDescriptionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUpdateDescription 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUpdateDescription primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUpdateDescription tblUpdateDescription
 	 */
	public function insert($tblUpdateDescription);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUpdateDescription tblUpdateDescription
 	 */
	public function update($tblUpdateDescription);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTblVersionId($value);

	public function queryByDescription($value);


	public function deleteByTblVersionId($value);

	public function deleteByDescription($value);


}
?>