-- phpMyAdmin SQL Dump
-- version 3.4.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Jan 11, 2017 at 08:08 PM
-- Server version: 1.0.109
-- PHP Version: 5.6.15

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `unlibooks_for_scp`
--

-- --------------------------------------------------------

--
-- Table structure for table `admin_coa`
--

CREATE TABLE IF NOT EXISTS `admin_coa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_num` varchar(100) NOT NULL,
  `account_type` enum('Assets','Liabilities','Income','Expense','Equity') NOT NULL,
  `account_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `sub_type` enum('main_sub','sub_sub') NOT NULL,
  `sub_account` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_num` (`account_num`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=124 ;

--
-- Dumping data for table `admin_coa`
--

INSERT INTO `admin_coa` (`id`, `account_num`, `account_type`, `account_name`, `sub_type`, `sub_account`) VALUES
(1, '1000', 'Assets', 'Cash and Cash Equivalent', '', ''),
(2, '1000-001', 'Assets', 'Petty Cash', 'main_sub', '1'),
(3, '1000-002', 'Assets', 'Cash on Hand', 'main_sub', '1'),
(4, '1000-003', 'Assets', 'Cash in Bank', 'main_sub', '1'),
(5, '1001', 'Assets', 'Accounts Receivable', '', ''),
(6, '1001-001', 'Assets', 'Trade Receivable', 'main_sub', '5'),
(7, '1001-002', 'Assets', 'Nontrade Receivable', 'main_sub', '5'),
(8, '1002', 'Assets', 'Other Current Assets', '', ''),
(9, '1002-001', 'Assets', 'Prepaid Rent', 'main_sub', '8'),
(10, '1002-002', 'Assets', 'Prepaid Insurance', 'main_sub', '8'),
(11, '1002-003', 'Assets', 'Security Deposits', 'main_sub', '8'),
(12, '1002-004', 'Assets', 'Input Tax', 'main_sub', '8'),
(13, '1002-005', 'Assets', 'Creditable Withholding Tax', 'main_sub', '8'),
(14, '1002-006', 'Assets', 'Other  Current Assets', 'main_sub', '8'),
(15, '1003', 'Assets', 'Long-Term Investments', '', ''),
(16, '1003-001', 'Assets', 'Long-term Investments', 'main_sub', '15'),
(17, '1004', 'Assets', 'Property, plant and equipment', '', ''),
(18, '1004-001', 'Assets', 'Land', 'main_sub', '17'),
(19, '1004-002', 'Assets', 'Building - Cost', 'main_sub', '17'),
(20, '1004-003', 'Assets', 'Accumulated Depreciation - Building', 'main_sub', '17'),
(21, '1004-004', 'Assets', 'Leasehold Improvement - Cost', 'main_sub', '17'),
(22, '1004-005', 'Assets', 'Accumulated Depreciation - Leasehold Improvement', 'main_sub', '17'),
(23, '1004-006', 'Assets', 'Transportation Equipment - Cost', 'main_sub', '17'),
(24, '1004-007', 'Assets', 'Accumulated Depreciation - Transportation Equipment', 'main_sub', '17'),
(25, '1004-008', 'Assets', 'Office Equipment - Cost', 'main_sub', '17'),
(26, '1004-009', 'Assets', 'Accumulated Depreciation - Office Equipment', 'main_sub', '17'),
(27, '1004-010', 'Assets', 'Medical Equipment - Cost', 'main_sub', '17'),
(28, '1004-011', 'Assets', 'Accumulated Depreciation - Medical Equipment', 'main_sub', '17'),
(29, '1004-012', 'Assets', 'Computer Equipment - Cost', 'main_sub', '17'),
(30, '1004-013', 'Assets', 'Accumulated Depreciation - Computer Equipment', 'main_sub', '17'),
(31, '1005', 'Assets', 'Long-Term Receivables', '', ''),
(32, '1005-001', 'Assets', 'Loans Receivable', 'main_sub', '31'),
(33, '1005-002', 'Assets', 'Interest Receivable', 'main_sub', '31'),
(34, '1006', 'Assets', 'Intangible Assets', '', ''),
(35, '1006-001', 'Assets', 'Intagibles - Cost ', 'main_sub', '34'),
(36, '1006-002', 'Assets', 'Accumulated Amortization - Intangibles', 'main_sub', '34'),
(37, '1007', 'Assets', 'Other Assets', '', ''),
(38, '1007-001', 'Assets', 'Other Assets', 'main_sub', '37'),
(40, '2000', 'Liabilities', 'Current Liabilities', '', ''),
(41, '2000-001', 'Liabilities', 'Accounts Payable', 'main_sub', '40'),
(42, '2000-002', 'Liabilities', 'Accrued Expenses', 'main_sub', '40'),
(43, '2000-003', 'Liabilities', 'SSS, PhilHealth, HDMF Premium Payable', 'main_sub', '40'),
(44, '2000-004', 'Liabilities', 'SSS, PhilHealth, HDMF Loan Payable', 'main_sub', '40'),
(45, '2000-005', 'Liabilities', 'Output Tax', 'main_sub', '40'),
(46, '2000-006', 'Liabilities', 'VAT Payable', 'main_sub', '40'),
(47, '2000-007', 'Liabilities', 'Percentage Tax Payable', 'main_sub', '40'),
(48, '2000-008', 'Liabilities', 'Withholding Tax - Compensation Payable', 'main_sub', '40'),
(49, '2000-009', 'Liabilities', 'Withholding Tax - Expanded Payable', 'main_sub', '40'),
(50, '2000-010', 'Liabilities', 'Income Tax Payable', 'main_sub', '40'),
(51, '2001', 'Liabilities', 'Long-term Liabilities', '', ''),
(52, '2001-001', 'Liabilities', 'Loans Payable', 'main_sub', '51'),
(53, '2001-002', 'Liabilities', 'Interest Payable', 'main_sub', '51'),
(54, '2002', 'Liabilities', 'Deferred Credits', '', ''),
(55, '2002-001', 'Liabilities', 'Deferred Credits', 'main_sub', '54'),
(56, '2003', 'Liabilities', 'Other Liabilities', '', ''),
(57, '2003-001', 'Liabilities', 'Other Liabilities', 'main_sub', '56'),
(59, '3000', 'Equity', 'Capital', '', ''),
(60, '3001', 'Equity', 'Net Operating  Income / Loss', '', ''),
(61, '3002', 'Equity', 'Drawings', '', ''),
(63, '4000', 'Income', 'Service Revenue', '', ''),
(64, '4000-001', 'Income', 'Professional Service Income', 'main_sub', '63'),
(65, '4000-002', 'Income', 'Service Discounts', 'main_sub', '63'),
(66, '4001', 'Income', 'Other Income', '', ''),
(67, '4001-001', 'Income', 'Dividend Income', 'main_sub', '66'),
(68, '4001-002', 'Income', 'Royalty Income', 'main_sub', '66'),
(69, '4001-003', 'Income', 'Miscellaneous/Other Income', 'main_sub', '66'),
(70, '6000', 'Expense', 'Cost of Services', '', ''),
(71, '6000-001', 'Expense', 'Direct Charges - Salaries, Wages and Benefits (Taxable)', 'main_sub', '70'),
(72, '6000-002', 'Expense', 'Direct Charges - Salaries, Wages and Benefits (Non-Taxable)', 'main_sub', '70'),
(73, '6000-003', 'Expense', 'Direct Charges - Materials, Supplies and Facilities', 'main_sub', '70'),
(74, '6000-004', 'Expense', 'Direct Charges - Depreciation', 'main_sub', '70'),
(75, '6000-005', 'Expense', 'Direct Charges - Rental', 'main_sub', '70'),
(76, '6000-006', 'Expense', 'Direct Charges - Outside Services', 'main_sub', '70'),
(77, '6000-007', 'Expense', 'Direct Charges - Others', 'main_sub', '70'),
(78, '6001', 'Expense', 'General Administrative and Selling Expenses', '', ''),
(79, '6001-001', 'Expense', 'Advertising and Promotions', 'main_sub', '78'),
(80, '6001-002', 'Expense', 'Amortizations', 'main_sub', '78'),
(81, '6001-003', 'Expense', 'Bad Debts', 'main_sub', '78'),
(82, '6001-004', 'Expense', 'Charitable Contributions', 'main_sub', '78'),
(83, '6001-005', 'Expense', 'Commissions', 'main_sub', '78'),
(84, '6001-006', 'Expense', 'Communication, Light and Water', 'main_sub', '78'),
(85, '6001-007', 'Expense', 'Depletion', 'main_sub', '78'),
(86, '6001-008', 'Expense', 'Depreciation', 'main_sub', '78'),
(87, '6001-009', 'Expense', 'Directors Fees', 'main_sub', '78'),
(88, '6001-010', 'Expense', 'Fringe Benefits', 'main_sub', '78'),
(89, '6001-011', 'Expense', 'Fuel and Oil', 'main_sub', '78'),
(90, '6001-012', 'Expense', 'Insurance', 'main_sub', '78'),
(91, '6001-013', 'Expense', 'Interest', 'main_sub', '78'),
(92, '6001-014', 'Expense', 'Janitorial and Messengerial Services', 'main_sub', '78'),
(93, '6001-015', 'Expense', 'Losses', 'main_sub', '78'),
(94, '6001-016', 'Expense', 'Management and Consultancy Fee', 'main_sub', '78'),
(95, '6001-017', 'Expense', 'Miscellaneous', 'main_sub', '78'),
(96, '6001-018', 'Expense', 'Office Supplies', 'main_sub', '78'),
(97, '6001-019', 'Expense', 'Other Services', 'main_sub', '78'),
(98, '6001-020', 'Expense', 'Professional Fees', 'main_sub', '78'),
(99, '6001-021', 'Expense', 'Rental', 'main_sub', '78'),
(100, '6001-022', 'Expense', 'Repairs and Maintenance - Labor or Labor & Materials', 'main_sub', '78'),
(101, '6001-023', 'Expense', 'Repairs and Maintenance - Materials/Supplies', 'main_sub', '78'),
(102, '6001-024', 'Expense', 'Representation and Entertainment', 'main_sub', '78'),
(103, '6001-025', 'Expense', 'Research and Development', 'main_sub', '78'),
(104, '6001-026', 'Expense', 'Royalties', 'main_sub', '78'),
(105, '6001-027', 'Expense', 'Salaries and Allowances (Taxable)', 'main_sub', '78'),
(106, '6001-028', 'Expense', 'Salaries and Allowances (Non-Taxable)', 'main_sub', '78'),
(107, '6001-029', 'Expense', 'Security Services', 'main_sub', '78'),
(108, '6001-030', 'Expense', 'SSS, GSIS, PhilHealth, HDMF and Other Contributions', 'main_sub', '78'),
(109, '6001-031', 'Expense', 'Taxes and Licenses', 'main_sub', '78'),
(110, '6001-032', 'Expense', 'Tolling Fees', 'main_sub', '78'),
(111, '6001-033', 'Expense', 'Trainings and Seminars', 'main_sub', '78'),
(112, '6001-034', 'Expense', 'Transportation and Travel', 'main_sub', '78'),
(113, '6001-035', 'Expense', 'Others', 'main_sub', '78'),
(114, '6002', 'Expense', 'Provision for Income Tax', '', ''),
(115, '6002-001', 'Expense', 'Regular Income Tax', 'main_sub', '114'),
(116, '4001-004', 'Income', 'Interest Income', 'main_sub', '66'),
(117, '2000-011', 'Liabilities', 'Deferred Income', 'main_sub', '40'),
(118, '2000-001-001', 'Liabilities', 'Trade Payable', 'sub_sub', '41'),
(119, '2000-001-002', 'Liabilities', 'Nontrade Payable', 'sub_sub', '41'),
(120, '1001-002-001', 'Assets', 'Advances to Officers/Employees', 'sub_sub', '7'),
(121, '1001-002-002', 'Assets', 'Advances for Officer/Employee - (Salary Deduction)', 'sub_sub', '7'),
(122, '7000', 'Expense', 'Suspense Account', 'main_sub', ''),
(123, '7000-001', 'Expense', 'Suspense Account', 'sub_sub', '122');

-- --------------------------------------------------------

--
-- Table structure for table `admin_user`
--

CREATE TABLE IF NOT EXISTS `admin_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_address` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `am_api_product`
--

CREATE TABLE IF NOT EXISTS `am_api_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `package` varchar(40) NOT NULL,
  `type` enum('monthly','annual') NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `am_api_subscription`
--

CREATE TABLE IF NOT EXISTS `am_api_subscription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ub_user_id` int(11) NOT NULL,
  `am_user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `date_start` datetime NOT NULL,
  `expiration` datetime NOT NULL,
  `receipt_id` text NOT NULL,
  `status` enum('active','expired') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ub_user_id` (`ub_user_id`,`am_user_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

INSERT INTO `am_api_product` (`id`, `title`, `package`, `type`, `description`) VALUES (NULL, 'UBSCP', 'Basic', 'monthly', '');

--
-- Table structure for table `tbl_all_bill_payable`
--

CREATE TABLE IF NOT EXISTS `tbl_all_bill_payable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `op_amount` double NOT NULL,
  `enter_bill_payment_id` int(11) NOT NULL,
  `payable_amount_id` int(11) DEFAULT NULL,
  `purchase_journal_lines_id` int(11) DEFAULT NULL,
  `pettycash_amount_id` int(11) DEFAULT NULL,
  `applied_amount` double NOT NULL,
  `wht_amount` double NOT NULL,
  `total_balance` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enter_bill_payment_id_2` (`enter_bill_payment_id`),
  KEY `payable_amount_id` (`payable_amount_id`),
  KEY `purchase_journal_lines_id` (`purchase_journal_lines_id`),
  KEY `pettycash_amount_id` (`pettycash_amount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_all_cash_invoice`
--

CREATE TABLE IF NOT EXISTS `tbl_all_cash_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_cash_invoice_id` int(11) DEFAULT NULL,
  `new_recurring_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `new_invoice_id` (`new_cash_invoice_id`),
  KEY `time_tracking_id` (`new_recurring_id`),
  KEY `new_recurring_id` (`new_recurring_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_all_collection`
--

CREATE TABLE IF NOT EXISTS `tbl_all_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `op_amount` double NOT NULL,
  `enter_payment_id` int(11) DEFAULT NULL,
  `invoiced_amount_id` int(11) DEFAULT NULL,
  `sales_journal_lines_id` int(11) DEFAULT NULL,
  `applied_amount` double NOT NULL,
  `wht_amount` double NOT NULL,
  `total_balance` double NOT NULL,
  `vatable_amount` double NOT NULL,
  `exempt_amount` double NOT NULL,
  `zero_rated_amount` double NOT NULL,
  `non_vat_amount` double NOT NULL,
  `vat_amount` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enter_payment_id` (`enter_payment_id`),
  KEY `invoiced_amount_id` (`invoiced_amount_id`),
  KEY `sales_journal_lines_id` (`sales_journal_lines_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_all_invoice`
--

CREATE TABLE IF NOT EXISTS `tbl_all_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_invoice_id` int(11) DEFAULT NULL,
  `new_recurring_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `new_invoice_id` (`new_invoice_id`),
  KEY `time_tracking_id` (`new_recurring_id`),
  KEY `new_recurring_id` (`new_recurring_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------


-- --------------------------------------------------------
-- --------------------------------------------------------

--
-- Table structure for table `tbl_all_pc_replenishment`
--

CREATE TABLE IF NOT EXISTS `tbl_all_pc_replenishment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `op_amount` double NOT NULL,
  `enter_bill_payment_id` int(11) NOT NULL,
  `payable_amount_id` int(11) DEFAULT NULL,
  `purchase_journal_lines_id` int(11) DEFAULT NULL,
  `applied_amount` double NOT NULL,
  `wht_amount` double NOT NULL,
  `total_balance` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enter_bill_payment_id_2` (`enter_bill_payment_id`),
  KEY `payable_amount_id` (`payable_amount_id`),
  KEY `purchase_journal_lines_id` (`purchase_journal_lines_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_all_pc_replenishment`
--


--
-- Table structure for table `tbl_atc_1601e`
--

CREATE TABLE IF NOT EXISTS `tbl_atc_1601e` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1601e_id` int(11) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `atc_code` varchar(100) NOT NULL,
  `amount` double NOT NULL,
  `rate` text NOT NULL,
  `tax_required` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1601e_id` (`form_1601e_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_atp`
--

CREATE TABLE IF NOT EXISTS `tbl_atp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `bklts` varchar(100) NOT NULL,
  `trans_date` date NOT NULL,
  `series_from` varchar(100) NOT NULL,
  `series_to` varchar(100) NOT NULL,
  `atp_no` varchar(100) NOT NULL,
  `date_issued` date NOT NULL,
  `date_validity` date NOT NULL,
  `name` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `tin` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_bank`
--

CREATE TABLE IF NOT EXISTS `tbl_bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(100) DEFAULT NULL,
  `bank_code` varchar(15) DEFAULT NULL,
  `bank_name` varchar(100) DEFAULT NULL,
  `bank_account_number` varchar(100) DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_cash_advance_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_cash_advance_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_cash_advance_id` int(11) NOT NULL,
  `sub_total_amount` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `new_cash_advance_id` (`new_cash_advance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_cash_advance_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_cash_advance_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_cash_advance_id` int(11) NOT NULL,
  `account_name` varchar(100) NOT NULL,
  `particular` varchar(100) NOT NULL,
  `cost_center` enum('CFC','HOLD','SFC','ANCOP','GENERAL') NOT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `new_cash_advance_id` (`new_cash_advance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_cash_invoice_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_cash_invoice_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `all_cash_invoice_id` int(11) NOT NULL,
  `sub_total_amount` double DEFAULT NULL,
  `vat_amount` double DEFAULT NULL,
  `discount_amount` double NOT NULL,
  `discount_line_amount` double NOT NULL,
  `discount_peso_amount` double NOT NULL,
  `grand_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `all_invoice_id` (`all_cash_invoice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_cash_invoice_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_cash_invoice_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_cash_invoice_id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `description` varchar(100) NOT NULL,
  `particular` text NOT NULL,
  `vat_id` int(11) NOT NULL,
  `discount_line` double NOT NULL,
  `rate` double NOT NULL,
  `unit_cost` double NOT NULL,
  `hour` double DEFAULT NULL,
  `quantity` double DEFAULT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `task_id` (`task_id`),
  KEY `new_invoice_id` (`new_cash_invoice_id`),
  KEY `vat_id` (`vat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_client`
--

CREATE TABLE IF NOT EXISTS `tbl_client` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `client_account` varchar(15) DEFAULT NULL,
  `client_name` varchar(100) DEFAULT NULL,
  `address` text,
  `tin_num` varchar(30) DEFAULT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `phone_number` varchar(30) DEFAULT NULL,
  `fax_number` varchar(30) DEFAULT NULL,
  `contact_name` varchar(100) DEFAULT NULL,
  `contact_num` varchar(30) DEFAULT NULL,
  `contact_email_address` varchar(100) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `currency_id` (`currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_coa`
--

CREATE TABLE IF NOT EXISTS `tbl_coa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `account_num` varchar(30) DEFAULT NULL,
  `account_type` enum('assets','liabilities','income','expense','equity') DEFAULT NULL,
  `accont_name` varchar(100) DEFAULT NULL,
  `sub_type` enum('main_sub','sub_sub') NOT NULL,
  `sub_account` varchar(100) NOT NULL,
  `fund_balance` double NOT NULL,
  `active_account` enum('yes','no') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_comment`
--

CREATE TABLE IF NOT EXISTS `tbl_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_cost_center`
--

CREATE TABLE IF NOT EXISTS `tbl_cost_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost_center_no` varchar(100) NOT NULL,
  `cost_center_desc` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_currency`
--

CREATE TABLE IF NOT EXISTS `tbl_currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `currency_code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=52 ;

--
-- Dumping data for table `tbl_currency`
--

INSERT INTO `tbl_currency` (`id`, `code`, `description`) VALUES
(1, 'AED', 'United Arab Emirates dirham'),
(2, 'AUD', 'Australian dollar'),
(3, 'BGL', 'Bulgarian leva'),
(4, 'BND', 'Brunei Darussalem dollar'),
(5, 'BRL', 'Brazilian real'),
(6, 'CAD', 'Canadian dollar'),
(7, 'CHF', 'Swiss franc'),
(8, 'CSD', 'Serbian Dinar'),
(9, 'CZK', 'Czech koruna'),
(10, 'DKK', 'Danish krone'),
(11, 'DZD', 'Algerian dinar'),
(12, 'EEK', 'Estonian kroon'),
(13, 'EUR', 'Euro'),
(14, 'FJD', 'Fiji dollar'),
(15, 'GBP', 'Pound Sterling'),
(16, 'HKD', 'Hong Kong dollar'),
(17, 'HRK', 'Croatian Kuna'),
(18, 'HUF', 'Hungarian forint'),
(19, 'IDR', 'Indonesian rupiah'),
(20, 'INR', 'Indian rupee'),
(21, 'ISK', 'Icelandic krona'),
(22, 'JPY', 'Japanese yen'),
(23, 'KES', 'Kenyan Shilling'),
(24, 'LTL', 'Lithuanian litas'),
(25, 'LVL', 'Latvian lats'),
(26, 'MAD', 'Moroccan dirham'),
(27, 'MXP', 'Mexican peso'),
(28, 'MYR', 'Malaysian ringgit'),
(29, 'MZM', 'Mozambique metical'),
(30, 'NGN', 'Nigerian naira'),
(31, 'NOK', 'Norwegian krone'),
(32, 'NZD', 'New Zealand dollar'),
(33, 'PHP', 'Philippines'),
(34, 'PLN', 'Polish zloty'),
(35, 'ROL', 'Romanian leu'),
(36, 'RUR', 'Russian ruble'),
(37, 'SAR', 'Saudi Arabian ryial'),
(38, 'SBD', 'Solomon Islands dollar'),
(39, 'SEK', 'Swedish krona'),
(40, 'SGD', 'Singapore dollar'),
(41, 'SIT', 'Slovenian tolar'),
(42, 'SKK', 'Slovak Koruna'),
(43, 'SZL', 'Swaziland lilangeni'),
(44, 'THB', 'Thai baht'),
(45, 'TND', 'Tunesian dinar'),
(46, 'TRY', 'New Turkish lira'),
(47, 'UGS', 'Ugandan Shilling'),
(48, 'USD', 'US dollar'),
(49, 'VUV', 'Vanuatu vatu'),
(50, 'WST', 'Western Samoan tala'),
(51, 'ZAR', 'South African rand');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_department`
--

CREATE TABLE IF NOT EXISTS `tbl_department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dept_no` varchar(100) NOT NULL,
  `dept_desc` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_employee`
--

CREATE TABLE IF NOT EXISTS `tbl_employee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_no` varchar(100) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `mid_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `position` varchar(100) NOT NULL,
  `category` varchar(100) NOT NULL,
  `emp_email` varchar(100) NOT NULL,
  `emp_dept` int(11) NOT NULL,
  `emp_costc` int(11) NOT NULL,
  `emp_group` int(11) NOT NULL,
  `assigned_loc` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `emp_dept` (`emp_dept`,`emp_costc`,`emp_group`),
  KEY `emp_group` (`emp_group`),
  KEY `emp_costc` (`emp_costc`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_enter_bill_payment`
--

CREATE TABLE IF NOT EXISTS `tbl_enter_bill_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `col_num` varchar(100) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `gl_posting` int(11) NOT NULL,
  `amount_received` double DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `date_received` date DEFAULT NULL,
  `ref_num` varchar(30) NOT NULL,
  `cas_no` varchar(100) NOT NULL,
  `mop_id` int(11) DEFAULT NULL,
  `over_payment` enum('yes','no') NOT NULL,
  `wht_tax` enum('1','2','10','15','0') NOT NULL DEFAULT '0',
  `received_2307` enum('yes','no') NOT NULL,
  `check_date` date NOT NULL,
  `status` enum('posted','reversed') NOT NULL,
  `notes` text,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `gl_posting` (`gl_posting`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_enter_payment`
--

CREATE TABLE IF NOT EXISTS `tbl_enter_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `col_num` varchar(100) NOT NULL,
  `client_id` int(11) NOT NULL,
  `time_tracking_id` int(11) DEFAULT NULL,
  `amount_received` double DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `date_received` date DEFAULT NULL,
  `ref_num` varchar(30) NOT NULL,
  `cas_no` varchar(100) NOT NULL,
  `mop_id` int(11) DEFAULT NULL,
  `over_payment` enum('yes','no') NOT NULL,
  `wht_tax` enum('1','2','10','15','0') NOT NULL DEFAULT '0',
  `received_2307` enum('yes','no') NOT NULL,
  `check_date` date NOT NULL,
  `status` enum('posted','reversed') NOT NULL,
  `notes` text,
  PRIMARY KEY (`id`),
  KEY `mop_id` (`mop_id`),
  KEY `time_tracking_id` (`time_tracking_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_expense_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_expense_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_expense_id` int(11) DEFAULT NULL,
  `sub_total_amount` double DEFAULT NULL,
  `discount_amount` double NOT NULL,
  `vat_amount` double DEFAULT NULL,
  `ewt_amount` double NOT NULL,
  `grand_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `new_expense_id` (`new_expense_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_expense_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_expense_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_expense_id` int(11) NOT NULL,
  `coa_id` int(11) DEFAULT NULL,
  `description_memo` varchar(100) DEFAULT NULL,
  `vat_id` int(11) NOT NULL,
  `EWT` enum('0','1','2','5','10','15') NOT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `coa_id` (`coa_id`),
  KEY `new_expense_id` (`new_expense_id`),
  KEY `vat_id` (`vat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_0605`
--

CREATE TABLE IF NOT EXISTS `tbl_form_0605` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_period_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1` enum('Calendar','Fiscal') NOT NULL,
  `item_2` date NOT NULL,
  `item_3` enum('1st','2nd','3rd','4th') NOT NULL,
  `item_4` date NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` date NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` enum('I','N') NOT NULL,
  `item_12` varchar(100) NOT NULL,
  `item_13` varchar(100) NOT NULL,
  `item_14` varchar(100) NOT NULL,
  `item_15` varchar(100) NOT NULL,
  `item_16` varchar(100) NOT NULL,
  `item_17` enum('Self-Assessment','Penalties','Tax Deposit/Advance Payment','Income Tax Second Installment','Others','Prelimenary','Accounts Receivable') NOT NULL,
  `item_17_payment_others` varchar(100) NOT NULL,
  `item_18` enum('Installment','Partial Payment','Full Payment') NOT NULL,
  `item_18_Installment` varchar(100) NOT NULL,
  `item_19` varchar(100) NOT NULL,
  `item_20A` varchar(100) NOT NULL,
  `item_20B` varchar(100) NOT NULL,
  `item_20C` varchar(100) NOT NULL,
  `item_20D` double NOT NULL,
  `item_21` varchar(100) NOT NULL,
  `approved_by` enum('pre','not') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_period_id` (`taxable_period_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1601c`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1601c` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1` date NOT NULL,
  `item_2` enum('yes','no') NOT NULL,
  `item_3` varchar(100) NOT NULL,
  `item_4` enum('yes','no') NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` varchar(100) NOT NULL,
  `item_12` enum('private','government') NOT NULL,
  `item_13` enum('yes','no') NOT NULL,
  `item_13_specify` varchar(100) NOT NULL,
  `item_14` varchar(100) NOT NULL,
  `part_2_item_15` varchar(100) DEFAULT NULL,
  `part_2_item_16A` varchar(100) DEFAULT NULL,
  `part_2_item_16B` varchar(100) DEFAULT NULL,
  `part_2_item_16C` varchar(100) DEFAULT NULL,
  `part_2_item_17` varchar(100) DEFAULT NULL,
  `part_2_item_18` varchar(100) DEFAULT NULL,
  `part_2_item_19` varchar(100) DEFAULT NULL,
  `part_2_item_20` varchar(100) DEFAULT NULL,
  `part_2_item_21A` varchar(100) DEFAULT NULL,
  `part_2_item_21B` varchar(100) DEFAULT NULL,
  `part_2_item_22` varchar(100) DEFAULT NULL,
  `part_2_item_23` varchar(100) DEFAULT NULL,
  `part_2_item_24A` varchar(100) DEFAULT NULL,
  `part_2_item_24B` varchar(100) DEFAULT NULL,
  `part_2_item_24C` varchar(100) DEFAULT NULL,
  `part_2_item_24D` varchar(100) DEFAULT NULL,
  `part_2_item_25` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1601e`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1601e` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1` date NOT NULL,
  `item_2` enum('yes','no') NOT NULL,
  `item_3` varchar(100) NOT NULL,
  `item_4` enum('yes','no') NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` varchar(100) NOT NULL,
  `item_12` enum('private','government') NOT NULL,
  `item_13` enum('yes','no') NOT NULL,
  `item_13_specify` varchar(100) NOT NULL,
  `item_14` varchar(100) DEFAULT NULL,
  `item_15A` varchar(100) DEFAULT NULL,
  `item_15B` int(11) NOT NULL,
  `item_15C` int(11) NOT NULL,
  `item_16` varchar(100) DEFAULT NULL,
  `item_17A` varchar(100) DEFAULT NULL,
  `item_17B` varchar(100) DEFAULT NULL,
  `item_17C` varchar(100) DEFAULT NULL,
  `item_17D` int(11) NOT NULL,
  `item_18` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_period_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_period_id` (`taxable_period_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701q`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701q` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1` varchar(100) NOT NULL,
  `item_2` enum('1st','2nd','3rd') NOT NULL,
  `item_3` enum('yes','no') NOT NULL,
  `item_4` varchar(100) NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` varchar(100) NOT NULL,
  `item_12` varchar(100) NOT NULL,
  `item_13` date NOT NULL,
  `item_14` varchar(100) NOT NULL,
  `item_15` varchar(100) NOT NULL,
  `item_16` date NOT NULL,
  `item_17` varchar(100) NOT NULL,
  `item_18` varchar(100) NOT NULL,
  `item_19` varchar(100) NOT NULL,
  `item_20_atc_1` varchar(100) NOT NULL,
  `item_20_atc_2` varchar(100) NOT NULL,
  `item_20_atc_3` varchar(100) NOT NULL,
  `item_20_compensation` varchar(100) NOT NULL,
  `item_20_business` varchar(100) NOT NULL,
  `item_20_mixed_income` varchar(100) NOT NULL,
  `item_21` varchar(100) NOT NULL,
  `item_22_atc_1` varchar(100) NOT NULL,
  `item_22_atc_2` varchar(100) NOT NULL,
  `item_22_atc_3` varchar(100) NOT NULL,
  `item_22_compensation` varchar(100) NOT NULL,
  `item_22_business` varchar(100) NOT NULL,
  `item_22_mixed_income` varchar(100) NOT NULL,
  `item_23_itemized` varchar(100) NOT NULL,
  `item_23_osd` varchar(100) NOT NULL,
  `item_24_itemized` varchar(100) NOT NULL,
  `item_24_osd` varchar(100) NOT NULL,
  `item_25` enum('yes','no') NOT NULL,
  `item_25_specify` varchar(100) NOT NULL,
  `ITR_1701Q_26A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_27A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_28A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_29A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_30A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_31A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_32A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_33A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_34A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_35A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_36A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_37A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_26B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_27B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_28B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_29B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_30B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_31B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_32B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_33B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_34B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_35B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_36B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_37B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38C` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38D` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38E` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38F` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38G` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38H` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38I` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38J` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38K` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38L` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38M` varchar(100) DEFAULT NULL,
  `ITR_1701Q_38N` varchar(100) DEFAULT NULL,
  `ITR_1701Q_39A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_39B` varchar(100) NOT NULL,
  `ITR_1701Q_40A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40C` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40D` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40E` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40F` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40G` varchar(100) DEFAULT NULL,
  `ITR_1701Q_40H` varchar(100) DEFAULT NULL,
  `ITR_1701Q_41A` varchar(100) DEFAULT NULL,
  `ITR_1701Q_41B` varchar(100) DEFAULT NULL,
  `ITR_1701Q_41C` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_old`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_old` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item1_month` date NOT NULL,
  `item1_year` date NOT NULL,
  `amended` enum('yes','no') NOT NULL,
  `short_period` enum('yes','no') NOT NULL,
  `alpha` enum('comp','business','mixed') NOT NULL,
  `taxpayer_tin` varchar(100) NOT NULL,
  `rdo` varchar(100) NOT NULL,
  `tax_filer` enum('single','prof','estate','trust') NOT NULL,
  `tax_filer_name` varchar(100) NOT NULL,
  `trade_name` varchar(100) NOT NULL,
  `reg_address` varchar(100) NOT NULL,
  `date_of_birth` date NOT NULL,
  `email` varchar(100) NOT NULL,
  `contact_num` varchar(100) NOT NULL,
  `civil_status` enum('single','married','separated','widow') NOT NULL,
  `item_15` enum('with_income','no_income') NOT NULL,
  `item_16` enum('filing','joint','separate') NOT NULL,
  `item_17` varchar(100) NOT NULL,
  `item_18` varchar(100) NOT NULL,
  `item_19` varchar(100) NOT NULL,
  `item_20` enum('itemized','osd') NOT NULL,
  `item_21` enum('cash','accrual','others') NOT NULL,
  `item_22` enum('yes','no') NOT NULL,
  `item_23` enum('yes','no') NOT NULL,
  `item_24` enum('yes','no') NOT NULL,
  `item_25` enum('1','2','3','4') NOT NULL,
  `pg1_item_26` varchar(100) DEFAULT NULL,
  `pg1_item_27` varchar(100) DEFAULT NULL,
  `pg1_item_28` varchar(100) DEFAULT NULL,
  `pg1_item_29` varchar(100) DEFAULT NULL,
  `pg1_item_30` varchar(100) DEFAULT NULL,
  `pg1_item_31` varchar(100) DEFAULT NULL,
  `pg1_item_32` varchar(100) DEFAULT NULL,
  `over_payment_type` enum('refunded','issued','carried') NOT NULL,
  `pg2_item_41_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_42_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_43_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_44_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_45_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_46_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_47_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_48_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_49_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_50_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_51_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_52_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_53_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_54_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_55_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_56_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_57_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_58_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_59_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_60_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_61_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_62_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_63_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_64_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_65_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_66_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_67_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_41_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_42_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_43_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_44_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_45_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_46_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_47_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_48_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_49_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_50_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_51_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_52_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_53_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_54_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_55_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_56_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_57_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_58_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_59_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_60_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_61_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_62_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_63_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_64_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_65_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_66_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_67_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_68_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_69_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_70_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_71_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_72_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_73_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_74_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_75_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_76_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_77_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_86_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_87_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_88_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_89_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_90_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_91_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_92_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_93_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_68_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_69_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_70_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_71_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_72_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_73_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_74_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_75_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_76_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_77_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_78_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_79_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_80_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_81_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_82_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_83_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_84_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_85_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_86_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_87_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_88_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_89_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_90_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_91_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_92_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_93_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_94_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_1_description` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_2_description` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_11_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_12_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_13_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_14_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_15_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_16_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_17_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_18_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_19_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_11_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_12_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_13_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_14_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_15_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_16_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_17_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_18_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_19_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_20_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_21_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_22_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_23_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_24_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_25_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_26_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_27_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_20_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_21_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_22_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_23_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_24_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_25_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_26_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_27_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_1_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_2_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_3_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_4_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_5_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_1_description` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_2_description` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_3_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_11_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_12_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_13_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_14_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_15_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_16_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_17_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_18_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_19_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_20_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_21_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_22_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_23_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_24_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_25_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_26_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_27_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_28_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_29_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_30_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_31_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_32_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_33_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_34_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_35_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_36_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_37_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_38_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_39_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_40_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_11_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_12_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_13_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_14_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_15_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_16_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_17_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_18_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_19_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_20_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_21_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_22_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_23_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_24_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_25_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_26_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_27_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_28_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_29_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_30_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_31_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_32_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_33_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_34_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_35_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_36_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_37_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_38_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_39_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_40_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_36_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_37_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_38_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_39_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_9_other` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_11_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_12_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_13_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_14_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_15_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_16_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_17_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_11_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_12_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_13_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_14_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_15_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_16_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_17_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_8a1_item_4_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_8` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_8` varchar(100) NOT NULL,
  `pg10_sched_11a_item_1` varchar(100) NOT NULL,
  `pg10_sched_11a_item_2a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_2b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_3a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_3b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_4` varchar(100) NOT NULL,
  `pg10_sched_11a_item_5a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_5b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_6a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_6b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_7a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_7b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_8a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_8b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_9` varchar(100) NOT NULL,
  `pg10_sched_11a_item_10` varchar(100) NOT NULL,
  `pg10_sched_11b_item_1` varchar(100) NOT NULL,
  `pg10_sched_11b_item_2a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_2b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_3a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_3b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_4` varchar(100) NOT NULL,
  `pg10_sched_11b_item_5a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_5b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_6a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_6b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_7a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_7b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_8a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_8b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_9` varchar(100) NOT NULL,
  `pg10_sched_11b_item_10` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_1exempt` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_1a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_1b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_2a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_2b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_3a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_3b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_4a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_4b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_5a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_5b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_6a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_6b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_7a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_7b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_8a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_8b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_9a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_9b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_10a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_10b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_11a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_11b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12a1` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12a2` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12b1` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12b2` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_13a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_13b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_14a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_14b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_15a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_15b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_16a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_16b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_17a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_17b` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18a1` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18b1` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18a2` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18b2` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_19a` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_19b` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_20a` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_20b` varchar(100) NOT NULL,
  `pg11_sched_12a_item_21` varchar(100) NOT NULL,
  `pg11_sched_12b_item_1` varchar(100) NOT NULL,
  `pg11_sched_12b_item_2` varchar(100) NOT NULL,
  `pg11_sched_12b_item_3` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_4a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_4b` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_5a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_5b` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_6a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_6b` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_7a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_7b` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_8a` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_8b` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_9a` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_9b` varchar(100) NOT NULL,
  `pg11_sched_12b_item_10` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_1`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `item1_month` date NOT NULL,
  `item1_year` date NOT NULL,
  `amended` enum('yes','no') NOT NULL,
  `short_period` enum('yes','no') NOT NULL,
  `alpha` enum('comp','business','mixed') NOT NULL,
  `taxpayer_tin` varchar(100) NOT NULL,
  `rdo` varchar(100) NOT NULL,
  `tax_filer` enum('single','prof','estate','trust') NOT NULL,
  `tax_filer_name` varchar(100) NOT NULL,
  `trade_name` varchar(100) NOT NULL,
  `reg_address` varchar(100) NOT NULL,
  `date_of_birth` date NOT NULL,
  `email` varchar(100) NOT NULL,
  `contact_num` varchar(100) NOT NULL,
  `civil_status` enum('single','married','separated','widow') NOT NULL,
  `item_15` enum('with_income','no_income') NOT NULL,
  `item_16` enum('filing','joint','separate') NOT NULL,
  `item_17` varchar(100) NOT NULL,
  `item_18` varchar(100) NOT NULL,
  `item_19` varchar(100) NOT NULL,
  `item_20` enum('itemized','osd') NOT NULL,
  `item_21` enum('cash','accrual','others') NOT NULL,
  `item_22` enum('yes','no') NOT NULL,
  `item_23` enum('yes','no') NOT NULL,
  `item_24` enum('yes','no') NOT NULL,
  `item_25` enum('1','2','3','4') NOT NULL,
  `pg1_item_26` varchar(100) DEFAULT NULL,
  `pg1_item_27` varchar(100) DEFAULT NULL,
  `pg1_item_28` varchar(100) DEFAULT NULL,
  `pg1_item_29` varchar(100) DEFAULT NULL,
  `pg1_item_30` varchar(100) DEFAULT NULL,
  `pg1_item_31` varchar(100) DEFAULT NULL,
  `pg1_item_32` varchar(100) DEFAULT NULL,
  `over_payment_type` enum('refunded','issued','carried') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_2`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_1d` int(11) NOT NULL,
  `pg2_item_41_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_42_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_43_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_44_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_45_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_46_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_47_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_48_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_49_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_50_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_51_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_52_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_53_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_54_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_55_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_56_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_57_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_58_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_59_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_60_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_61_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_62_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_63_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_64_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_65_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_66_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_67_taxpayer` varchar(100) DEFAULT NULL,
  `pg2_item_41_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_42_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_43_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_44_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_45_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_46_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_47_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_48_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_49_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_50_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_51_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_52_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_53_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_54_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_55_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_56_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_57_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_58_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_59_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_60_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_61_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_62_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_63_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_64_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_65_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_66_spouse` varchar(100) DEFAULT NULL,
  `pg2_item_67_spouse` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_1d` (`form_1701_1d`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_3`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg3_item_68_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_69_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_70_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_71_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_72_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_73_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_74_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_75_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_76_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_77_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_86_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_87_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_88_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_89_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_90_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_91_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_92_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_93_taxpayer` varchar(100) DEFAULT NULL,
  `pg3_item_68_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_69_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_70_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_71_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_72_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_73_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_74_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_75_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_76_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_77_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_78_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_79_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_80_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_81_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_82_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_83_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_84_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_85_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_86_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_87_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_88_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_89_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_90_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_91_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_92_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_93_spouse` varchar(100) DEFAULT NULL,
  `pg3_item_94_spouse` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_4`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_4` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `item_95` varchar(100) DEFAULT NULL,
  `item_96` varchar(100) DEFAULT NULL,
  `item_97` varchar(100) DEFAULT NULL,
  `item_98` varchar(100) DEFAULT NULL,
  `item_99` varchar(100) DEFAULT NULL,
  `item_100` varchar(100) DEFAULT NULL,
  `item_101` varchar(100) DEFAULT NULL,
  `item_102` varchar(100) DEFAULT NULL,
  `item_103` varchar(100) DEFAULT NULL,
  `item_104` varchar(100) DEFAULT NULL,
  `item_105` enum('itemized','osd') NOT NULL,
  `item_106` enum('cash','accrual','other') NOT NULL,
  `item_106_specify` varchar(100) DEFAULT NULL,
  `item_107` enum('yes','no') NOT NULL,
  `item_108` enum('yes','no') NOT NULL,
  `item_109` enum('011','012','013') NOT NULL,
  `item_110` enum('yes','no') NOT NULL,
  `item_111` varchar(100) DEFAULT NULL,
  `part_7a_last_name_1` varchar(100) DEFAULT NULL,
  `part_7a_last_name_2` varchar(100) DEFAULT NULL,
  `part_7a_last_name_3` varchar(100) DEFAULT NULL,
  `part_7a_last_name_4` varchar(100) DEFAULT NULL,
  `part_7a_first_name_initial_1` varchar(100) DEFAULT NULL,
  `part_7a_first_name_initial_2` varchar(100) DEFAULT NULL,
  `part_7a_first_name_initial_3` varchar(100) DEFAULT NULL,
  `part_7a_first_name_initial_4` varchar(100) DEFAULT NULL,
  `initial_1` varchar(100) NOT NULL,
  `initial_2` varchar(100) NOT NULL,
  `initial_3` varchar(100) NOT NULL,
  `initial_4` varchar(100) NOT NULL,
  `part_7a_date_of_birth_1` varchar(100) DEFAULT NULL,
  `part_7a_date_of_birth_2` varchar(100) DEFAULT NULL,
  `part_7a_date_of_birth_3` varchar(100) DEFAULT NULL,
  `part_7a_date_of_birth_4` varchar(100) DEFAULT NULL,
  `part_7a_mark_1` varchar(100) DEFAULT NULL,
  `part_7a_mark_2` varchar(100) DEFAULT NULL,
  `part_7a_mark_3` varchar(100) DEFAULT NULL,
  `part_7a_mark_4` varchar(100) DEFAULT NULL,
  `part_7b_unit` varchar(100) DEFAULT NULL,
  `part_7b_building` varchar(100) DEFAULT NULL,
  `part_7b_lot` varchar(100) DEFAULT NULL,
  `part_7b_street` varchar(100) DEFAULT NULL,
  `part_7b_sub` varchar(100) DEFAULT NULL,
  `part_7b_barangay` varchar(100) DEFAULT NULL,
  `part_7b_municipal` varchar(100) DEFAULT NULL,
  `part_7b_province` varchar(100) DEFAULT NULL,
  `part_7b_zip` varchar(100) DEFAULT NULL,
  `item_112` varchar(100) DEFAULT NULL,
  `item_113` varchar(100) DEFAULT NULL,
  `item_114` varchar(100) DEFAULT NULL,
  `item_115` varchar(100) DEFAULT NULL,
  `item_116` varchar(100) DEFAULT NULL,
  `item_117` varchar(100) DEFAULT NULL,
  `item_118` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_5`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg5_sched_1_item_1_taxpayer` varchar(100) NOT NULL,
  `pg5_sched_1_item_1_spouse` varchar(100) NOT NULL,
  `pg5_sched_1_item_1_tin` varchar(100) NOT NULL,
  `pg5_sched_1_item_1_comp` varchar(100) NOT NULL,
  `pg5_sched_1_item_1_tax` varchar(100) NOT NULL,
  `pg5_sched_1_item_2_taxpayer` varchar(100) NOT NULL,
  `pg5_sched_1_item_2_spouse` varchar(100) NOT NULL,
  `pg5_sched_1_item_2_tin` varchar(100) NOT NULL,
  `pg5_sched_1_item_2_comp` varchar(100) NOT NULL,
  `pg5_sched_1_item_2_tax` varchar(100) NOT NULL,
  `pg5_sched_1_item_3_taxpayer` varchar(100) NOT NULL,
  `pg5_sched_1_item_3_spouse` varchar(100) NOT NULL,
  `pg5_sched_1_item_3_tin` varchar(100) NOT NULL,
  `pg5_sched_1_item_3_comp` varchar(100) NOT NULL,
  `pg5_sched_1_item_3_tax` varchar(100) NOT NULL,
  `pg5_sched_1_item_4_taxpayer` varchar(100) NOT NULL,
  `pg5_sched_1_item_4_spouse` varchar(100) NOT NULL,
  `pg5_sched_1_item_4_tin` varchar(100) NOT NULL,
  `pg5_sched_1_item_4_comp` varchar(100) NOT NULL,
  `pg5_sched_1_item_4_tax` varchar(100) NOT NULL,
  `pg5_sched_1_item_5a_comp` varchar(100) NOT NULL,
  `pg5_sched_1_item_5a_tax` varchar(100) NOT NULL,
  `pg5_sched_1_item_5b_comp` varchar(100) NOT NULL,
  `pg5_sched_1_item_5b_tax` varchar(100) NOT NULL,
  `pg5_sched_2_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_2_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_1_description` varchar(100) DEFAULT NULL,
  `pg5_sched_3_item_2_description` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg5_sched_4_item_5_spouse` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_6`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_6` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg6_sched_4b_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_11_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_12_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_13_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_14_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_15_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_16_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_17_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_18_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_19_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_11_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_12_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_13_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_14_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_15_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_16_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_17_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_18_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4b_item_19_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_20_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_21_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_22_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_23_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_24_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_25_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_26_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_27_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_20_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_21_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_22_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_23_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_24_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_25_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_26_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_4c_item_27_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_1_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_2_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_3_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_4_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_5_item_5_nature_of_income` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_1_description` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_2_description` varchar(100) DEFAULT NULL,
  `pg6_sched_6_item_3_description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_7`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_7` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg7_sched_6_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_11_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_12_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_13_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_14_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_15_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_16_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_17_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_18_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_19_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_20_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_21_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_22_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_23_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_24_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_25_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_26_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_27_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_28_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_29_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_30_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_31_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_32_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_33_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_34_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_35_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_36_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_37_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_38_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_39_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_40_taxpayer` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_11_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_12_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_13_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_14_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_15_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_16_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_17_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_18_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_19_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_20_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_21_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_22_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_23_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_24_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_25_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_26_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_27_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_28_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_29_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_30_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_31_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_32_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_33_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_34_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_35_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_36_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_37_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_38_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_39_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_40_spouse` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_36_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_37_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_38_description` varchar(100) DEFAULT NULL,
  `pg7_sched_6_item_39_description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_8`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_8` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg8_sched_7_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_description` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_1_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_2_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_3_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_7_item_4_legal_basis` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_8a_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg8_sched_8a1_item_4_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_year` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_a` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_b` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_c` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_d` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_4_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_5_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_6_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_7_e` varchar(100) NOT NULL,
  `pg8_sched_8a1_item_8` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_year` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_a` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_b` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_c` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_d` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_4_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_5_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_6_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_7_e` varchar(100) NOT NULL,
  `pg8_sched_8b1_item_8` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_9`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_9` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg9_sched_9_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_9_item_9_other` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_1_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_2_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_3_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_4_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_5_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_6_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_7_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_8_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_9_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_10_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_11_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_12_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_13_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_14_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_15_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_16_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_17_taxpayer` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_1_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_2_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_3_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_4_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_5_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_6_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_7_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_8_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_9_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_10_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_11_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_12_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_13_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_14_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_15_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_16_spouse` varchar(100) DEFAULT NULL,
  `pg9_sched_10_item_17_spouse` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_10`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_10` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg10_sched_11a_item_1` varchar(100) NOT NULL,
  `pg10_sched_11a_item_2a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_2b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_3a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_3b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_4` varchar(100) NOT NULL,
  `pg10_sched_11a_item_5a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_5b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_6a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_6b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_7a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_7b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_8a` varchar(100) NOT NULL,
  `pg10_sched_11a_item_8b` varchar(100) NOT NULL,
  `pg10_sched_11a_item_9` varchar(100) NOT NULL,
  `pg10_sched_11a_item_10` varchar(100) NOT NULL,
  `pg10_sched_11b_item_1` varchar(100) NOT NULL,
  `pg10_sched_11b_item_2a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_2b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_3a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_3b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_4` varchar(100) NOT NULL,
  `pg10_sched_11b_item_5a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_5b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_6a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_6b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_7a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_7b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_8a` varchar(100) NOT NULL,
  `pg10_sched_11b_item_8b` varchar(100) NOT NULL,
  `pg10_sched_11b_item_9` varchar(100) NOT NULL,
  `pg10_sched_11b_item_10` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_11`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_11` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg11_sched_12a1_item_1exempt` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_1a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_1b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_2a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_2b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_3a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_3b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_4a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_4b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_5a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_5b` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_6a` varchar(100) NOT NULL,
  `pg11_sched_12a1_item_6b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_7a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_7b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_8a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_8b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_9a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_9b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_10a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_10b` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_11a` varchar(100) NOT NULL,
  `pg11_sched_12a2_item_11b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12a1` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12a2` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12b1` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_12b2` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_13a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_13b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_14a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_14b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_15a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_15b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_16a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_16b` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_17a` varchar(100) NOT NULL,
  `pg11_sched_12a3_item_17b` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18a1` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18b1` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18a2` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_18b2` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_19a` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_19b` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_20a` varchar(100) NOT NULL,
  `pg11_sched_12a4_item_20b` varchar(100) NOT NULL,
  `pg11_sched_12a_item_21` varchar(100) NOT NULL,
  `pg11_sched_12b_item_1` varchar(100) NOT NULL,
  `pg11_sched_12b_item_2` varchar(100) NOT NULL,
  `pg11_sched_12b_item_3` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_4a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_4b` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_5a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_5b` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_6a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_6b` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_7a` varchar(100) NOT NULL,
  `pg11_sched_12b1_item_7b` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_8a` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_8b` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_9a` varchar(100) NOT NULL,
  `pg11_sched_12b2_item_9b` varchar(100) NOT NULL,
  `pg11_sched_12b_item_10` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1701_page_12`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1701_page_12` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1701_id` int(11) NOT NULL,
  `pg12_part_9_item_1a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21h` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1701_id` (`form_1701_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_1702_part9_old`
--

CREATE TABLE IF NOT EXISTS `tbl_form_1702_part9_old` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_1702_id` int(11) NOT NULL,
  `pg12_part_9_item_1a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_1h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_2h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_3h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_4h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_5h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_6h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_7h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_8h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_9h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_10h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_11h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_12h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_13h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_14h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_15h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_16h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_17h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_18h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_19h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_20h` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21a` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21b` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21c` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21d` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21e` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21f` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21g` varchar(100) DEFAULT NULL,
  `pg12_part_9_item_21h` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_1702_id` (`form_1702_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tbl_form_1702_part9_old`
--

INSERT INTO `tbl_form_1702_part9_old` (`id`, `form_1702_id`, `pg12_part_9_item_1a`, `pg12_part_9_item_1b`, `pg12_part_9_item_1c`, `pg12_part_9_item_1d`, `pg12_part_9_item_1e`, `pg12_part_9_item_1f`, `pg12_part_9_item_1g`, `pg12_part_9_item_1h`, `pg12_part_9_item_2a`, `pg12_part_9_item_2b`, `pg12_part_9_item_2c`, `pg12_part_9_item_2d`, `pg12_part_9_item_2e`, `pg12_part_9_item_2f`, `pg12_part_9_item_2g`, `pg12_part_9_item_2h`, `pg12_part_9_item_3a`, `pg12_part_9_item_3b`, `pg12_part_9_item_3c`, `pg12_part_9_item_3d`, `pg12_part_9_item_3e`, `pg12_part_9_item_3f`, `pg12_part_9_item_3g`, `pg12_part_9_item_3h`, `pg12_part_9_item_4a`, `pg12_part_9_item_4b`, `pg12_part_9_item_4c`, `pg12_part_9_item_4d`, `pg12_part_9_item_4e`, `pg12_part_9_item_4f`, `pg12_part_9_item_4g`, `pg12_part_9_item_4h`, `pg12_part_9_item_5a`, `pg12_part_9_item_5b`, `pg12_part_9_item_5c`, `pg12_part_9_item_5d`, `pg12_part_9_item_5e`, `pg12_part_9_item_5f`, `pg12_part_9_item_5g`, `pg12_part_9_item_5h`, `pg12_part_9_item_6a`, `pg12_part_9_item_6b`, `pg12_part_9_item_6c`, `pg12_part_9_item_6d`, `pg12_part_9_item_6e`, `pg12_part_9_item_6f`, `pg12_part_9_item_6g`, `pg12_part_9_item_6h`, `pg12_part_9_item_7a`, `pg12_part_9_item_7b`, `pg12_part_9_item_7c`, `pg12_part_9_item_7d`, `pg12_part_9_item_7e`, `pg12_part_9_item_7f`, `pg12_part_9_item_7g`, `pg12_part_9_item_7h`, `pg12_part_9_item_8a`, `pg12_part_9_item_8b`, `pg12_part_9_item_8c`, `pg12_part_9_item_8d`, `pg12_part_9_item_8e`, `pg12_part_9_item_8f`, `pg12_part_9_item_8g`, `pg12_part_9_item_8h`, `pg12_part_9_item_9a`, `pg12_part_9_item_9b`, `pg12_part_9_item_9c`, `pg12_part_9_item_9d`, `pg12_part_9_item_9e`, `pg12_part_9_item_9f`, `pg12_part_9_item_9g`, `pg12_part_9_item_9h`, `pg12_part_9_item_10a`, `pg12_part_9_item_10b`, `pg12_part_9_item_10c`, `pg12_part_9_item_10d`, `pg12_part_9_item_10e`, `pg12_part_9_item_10f`, `pg12_part_9_item_10g`, `pg12_part_9_item_10h`, `pg12_part_9_item_11a`, `pg12_part_9_item_11b`, `pg12_part_9_item_11c`, `pg12_part_9_item_11d`, `pg12_part_9_item_11e`, `pg12_part_9_item_11f`, `pg12_part_9_item_11g`, `pg12_part_9_item_11h`, `pg12_part_9_item_12a`, `pg12_part_9_item_12b`, `pg12_part_9_item_12c`, `pg12_part_9_item_12d`, `pg12_part_9_item_12e`, `pg12_part_9_item_12f`, `pg12_part_9_item_12g`, `pg12_part_9_item_12h`, `pg12_part_9_item_13a`, `pg12_part_9_item_13b`, `pg12_part_9_item_13c`, `pg12_part_9_item_13d`, `pg12_part_9_item_13e`, `pg12_part_9_item_13f`, `pg12_part_9_item_13g`, `pg12_part_9_item_13h`, `pg12_part_9_item_14a`, `pg12_part_9_item_14b`, `pg12_part_9_item_14c`, `pg12_part_9_item_14d`, `pg12_part_9_item_14e`, `pg12_part_9_item_14f`, `pg12_part_9_item_14g`, `pg12_part_9_item_14h`, `pg12_part_9_item_15a`, `pg12_part_9_item_15b`, `pg12_part_9_item_15c`, `pg12_part_9_item_15d`, `pg12_part_9_item_15e`, `pg12_part_9_item_15f`, `pg12_part_9_item_15g`, `pg12_part_9_item_15h`, `pg12_part_9_item_16a`, `pg12_part_9_item_16b`, `pg12_part_9_item_16c`, `pg12_part_9_item_16d`, `pg12_part_9_item_16e`, `pg12_part_9_item_16f`, `pg12_part_9_item_16g`, `pg12_part_9_item_16h`, `pg12_part_9_item_17a`, `pg12_part_9_item_17b`, `pg12_part_9_item_17c`, `pg12_part_9_item_17d`, `pg12_part_9_item_17e`, `pg12_part_9_item_17f`, `pg12_part_9_item_17g`, `pg12_part_9_item_17h`, `pg12_part_9_item_18a`, `pg12_part_9_item_18b`, `pg12_part_9_item_18c`, `pg12_part_9_item_18d`, `pg12_part_9_item_18e`, `pg12_part_9_item_18f`, `pg12_part_9_item_18g`, `pg12_part_9_item_18h`, `pg12_part_9_item_19a`, `pg12_part_9_item_19b`, `pg12_part_9_item_19c`, `pg12_part_9_item_19d`, `pg12_part_9_item_19e`, `pg12_part_9_item_19f`, `pg12_part_9_item_19g`, `pg12_part_9_item_19h`, `pg12_part_9_item_20a`, `pg12_part_9_item_20b`, `pg12_part_9_item_20c`, `pg12_part_9_item_20d`, `pg12_part_9_item_20e`, `pg12_part_9_item_20f`, `pg12_part_9_item_20g`, `pg12_part_9_item_20h`, `pg12_part_9_item_21a`, `pg12_part_9_item_21b`, `pg12_part_9_item_21c`, `pg12_part_9_item_21d`, `pg12_part_9_item_21e`, `pg12_part_9_item_21f`, `pg12_part_9_item_21g`, `pg12_part_9_item_21h`) VALUES
(1, 1, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(2, 2, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(3, 3, '56', '567', '7', '2132', '', '', '', '', '567', '7657', '65', '', '21', '3', '2', '', '56567', '67', '76', '', '', '', '', '', '75', '7567', '677', '', '', '', '13', '', '65765', '76', '77', '', '', '', '', '', '765', '57', '67', '', '', '', '13', '', '765', '7657', '5656', '2133', '', '2', '', '', '57', '7', '65', '', '2', '', '', '', '657657', '7', '7', '', '', '3', '', '', '57657', '', '', '', '', '', '', '', '6576', '7', '576', '', '', '1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_2307`
--

CREATE TABLE IF NOT EXISTS `tbl_form_2307` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_period_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1_from` date NOT NULL,
  `item_1_to` date NOT NULL,
  `item_2` varchar(100) NOT NULL,
  `item_3` varchar(100) NOT NULL,
  `item_4` varchar(100) NOT NULL,
  `item_4A` varchar(100) NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_5A` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_8A` varchar(100) NOT NULL,
  `income_total` varchar(100) NOT NULL,
  `government_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_period_id` (`taxable_period_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_2307_part_2`
--

CREATE TABLE IF NOT EXISTS `tbl_form_2307_part_2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_2307_id` int(11) NOT NULL,
  `income_government` varchar(100) NOT NULL,
  `type` enum('Income','Government') NOT NULL,
  `atc` varchar(100) NOT NULL,
  `first_month` varchar(100) NOT NULL,
  `second_month` varchar(100) NOT NULL,
  `third_month` varchar(100) NOT NULL,
  `total` varchar(100) NOT NULL,
  `tax_withheld` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_2307_id` (`form_2307_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_2550m`
--

CREATE TABLE IF NOT EXISTS `tbl_form_2550m` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1` date NOT NULL,
  `item_2` enum('yes','no') NOT NULL,
  `item_3` varchar(100) NOT NULL,
  `item_4` varchar(100) NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` enum('yes','no') NOT NULL,
  `item_11_specify` varchar(100) NOT NULL,
  `part_2_item_12A` varchar(100) DEFAULT NULL,
  `part_2_item_12B` varchar(100) DEFAULT NULL,
  `part_2_item_13A` varchar(100) DEFAULT NULL,
  `part_2_item_13B` varchar(100) DEFAULT NULL,
  `part_2_item_14` varchar(100) DEFAULT NULL,
  `part_2_item_15` varchar(100) DEFAULT NULL,
  `part_2_item_16A` varchar(100) DEFAULT NULL,
  `part_2_item_16B` varchar(100) DEFAULT NULL,
  `part_2_item_17A` varchar(100) DEFAULT NULL,
  `part_2_item_17B` varchar(100) DEFAULT NULL,
  `part_2_item_17C` varchar(100) DEFAULT NULL,
  `part_2_item_17D` varchar(100) DEFAULT NULL,
  `part_2_item_17E` varchar(100) DEFAULT NULL,
  `part_2_item_17F` varchar(100) DEFAULT NULL,
  `part_2_item_18A` varchar(100) DEFAULT NULL,
  `part_2_item_18B` varchar(100) DEFAULT NULL,
  `part_2_item_18C` varchar(100) DEFAULT NULL,
  `part_2_item_18D` varchar(100) DEFAULT NULL,
  `part_2_item_18E` varchar(100) DEFAULT NULL,
  `part_2_item_18F` varchar(100) DEFAULT NULL,
  `part_2_item_18G` varchar(100) DEFAULT NULL,
  `part_2_item_18H` varchar(100) DEFAULT NULL,
  `part_2_item_18I` varchar(100) DEFAULT NULL,
  `part_2_item_18J` varchar(100) DEFAULT NULL,
  `part_2_item_18K` varchar(100) DEFAULT NULL,
  `part_2_item_18L` varchar(100) DEFAULT NULL,
  `part_2_item_18M` varchar(100) DEFAULT NULL,
  `part_2_item_18N` varchar(100) DEFAULT NULL,
  `part_2_item_18O` varchar(100) DEFAULT NULL,
  `part_2_item_18P` varchar(100) DEFAULT NULL,
  `part_2_item_19` varchar(100) DEFAULT NULL,
  `part_2_item_20A` varchar(100) DEFAULT NULL,
  `part_2_item_20B` varchar(100) DEFAULT NULL,
  `part_2_item_20C` varchar(100) DEFAULT NULL,
  `part_2_item_20D` varchar(100) DEFAULT NULL,
  `part_2_item_20E` varchar(100) DEFAULT NULL,
  `part_2_item_20F` varchar(100) DEFAULT NULL,
  `part_2_item_20G` varchar(100) DEFAULT NULL,
  `part_2_item_21` varchar(100) DEFAULT NULL,
  `part_2_item_22` varchar(100) DEFAULT NULL,
  `part_2_item_23A` varchar(100) DEFAULT NULL,
  `part_2_item_23B` varchar(100) DEFAULT NULL,
  `part_2_item_23C` varchar(100) DEFAULT NULL,
  `part_2_item_23D` varchar(100) DEFAULT NULL,
  `part_2_item_23E` varchar(100) DEFAULT NULL,
  `part_2_item_23F` varchar(100) DEFAULT NULL,
  `part_2_item_23G` varchar(100) NOT NULL,
  `part_2_item_24` varchar(100) DEFAULT NULL,
  `part_2_item_25A` varchar(100) DEFAULT NULL,
  `part_2_item_25B` varchar(100) DEFAULT NULL,
  `part_2_item_25C` varchar(100) DEFAULT NULL,
  `part_2_item_25D` varchar(100) DEFAULT NULL,
  `part_2_item_26` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_2550q`
--

CREATE TABLE IF NOT EXISTS `tbl_form_2550q` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `year_ended` enum('calendar','fiscal','','') NOT NULL,
  `month` varchar(100) NOT NULL,
  `year` date NOT NULL,
  `item_2` enum('1st','2nd','3rd','4th') NOT NULL,
  `item_3_from` date NOT NULL,
  `item_3_to` date NOT NULL,
  `item_4` enum('yes','no','','') NOT NULL,
  `item_5` enum('yes','no','','') NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` varchar(100) NOT NULL,
  `item_12` varchar(100) NOT NULL,
  `item_13` varchar(100) NOT NULL,
  `item_14` varchar(100) NOT NULL,
  `item_14_specify` varchar(100) NOT NULL,
  `part_2_item_15A` varchar(100) DEFAULT NULL,
  `part_2_item_15B` varchar(100) DEFAULT NULL,
  `part_2_item_16A` varchar(100) DEFAULT NULL,
  `part_2_item_16B` varchar(100) DEFAULT NULL,
  `part_2_item_17` varchar(100) DEFAULT NULL,
  `part_2_item_18` varchar(100) DEFAULT NULL,
  `part_2_item_19A` varchar(100) DEFAULT NULL,
  `part_2_item_19B` varchar(100) DEFAULT NULL,
  `part_2_item_20A` varchar(100) DEFAULT NULL,
  `part_2_item_20B` varchar(100) DEFAULT NULL,
  `part_2_item_20C` varchar(100) DEFAULT NULL,
  `part_2_item_20D` varchar(100) DEFAULT NULL,
  `part_2_item_20E` varchar(100) DEFAULT NULL,
  `part_2_item_20F` varchar(100) DEFAULT NULL,
  `part_2_item_21A` varchar(100) DEFAULT NULL,
  `part_2_item_21B` varchar(100) DEFAULT NULL,
  `part_2_item_21C` varchar(100) DEFAULT NULL,
  `part_2_item_21D` varchar(100) DEFAULT NULL,
  `part_2_item_21E` varchar(100) DEFAULT NULL,
  `part_2_item_21F` varchar(100) DEFAULT NULL,
  `part_2_item_21G` varchar(100) DEFAULT NULL,
  `part_2_item_21H` varchar(100) DEFAULT NULL,
  `part_2_item_21I` varchar(100) DEFAULT NULL,
  `part_2_item_21J` varchar(100) DEFAULT NULL,
  `part_2_item_21K` varchar(100) DEFAULT NULL,
  `part_2_item_21L` varchar(100) DEFAULT NULL,
  `part_2_item_21M` varchar(100) DEFAULT NULL,
  `part_2_item_21N` varchar(100) DEFAULT NULL,
  `part_2_item_21O` varchar(100) DEFAULT NULL,
  `part_2_item_21P` varchar(100) DEFAULT NULL,
  `part_2_item_22` varchar(100) DEFAULT NULL,
  `part_2_item_23A` varchar(100) DEFAULT NULL,
  `part_2_item_23B` varchar(100) DEFAULT NULL,
  `part_2_item_23C` varchar(100) DEFAULT NULL,
  `part_2_item_23D` varchar(100) DEFAULT NULL,
  `part_2_item_23E` varchar(100) DEFAULT NULL,
  `part_2_item_23F` varchar(100) DEFAULT NULL,
  `part_2_item_24` varchar(100) DEFAULT NULL,
  `part_2_item_25` varchar(100) DEFAULT NULL,
  `part_2_item_26A` varchar(100) DEFAULT NULL,
  `part_2_item_26B` varchar(100) DEFAULT NULL,
  `part_2_item_26C` varchar(100) DEFAULT NULL,
  `part_2_item_26D` varchar(100) DEFAULT NULL,
  `part_2_item_26E` varchar(100) DEFAULT NULL,
  `part_2_item_26F` varchar(100) DEFAULT NULL,
  `part_2_item_26G` varchar(100) DEFAULT NULL,
  `part_2_item_26H` varchar(100) DEFAULT NULL,
  `part_2_item_27` varchar(100) DEFAULT NULL,
  `part_2_item_28A` varchar(100) DEFAULT NULL,
  `part_2_item_28B` varchar(100) DEFAULT NULL,
  `part_2_item_28C` varchar(100) DEFAULT NULL,
  `part_2_item_28D` varchar(100) DEFAULT NULL,
  `part_2_item_29` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_form_2551m`
--

CREATE TABLE IF NOT EXISTS `tbl_form_2551m` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxable_peroid_id` int(11) NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `item_1` enum('calendar','fiscal') NOT NULL,
  `item_2` date NOT NULL,
  `item_3` date NOT NULL,
  `item_4` enum('yes','no') NOT NULL,
  `item_5` varchar(100) NOT NULL,
  `item_6` varchar(100) NOT NULL,
  `item_7` varchar(100) NOT NULL,
  `item_8` varchar(100) NOT NULL,
  `item_9` varchar(100) NOT NULL,
  `item_10` varchar(100) NOT NULL,
  `item_11` varchar(100) NOT NULL,
  `item_12` varchar(100) NOT NULL,
  `item_13` enum('yes','no') NOT NULL,
  `item_13_specify` varchar(100) NOT NULL,
  `ITR_2551M_14A` varchar(100) NOT NULL,
  `ITR_2551M_14B` varchar(100) NOT NULL,
  `ITR_2551M_14C` varchar(100) NOT NULL,
  `ITR_2551M_14D` varchar(100) NOT NULL,
  `ITR_2551M_14E` varchar(100) NOT NULL,
  `ITR_2551M_15A` varchar(100) NOT NULL,
  `ITR_2551M_15B` varchar(100) NOT NULL,
  `ITR_2551M_15C` varchar(100) NOT NULL,
  `ITR_2551M_15D` varchar(100) NOT NULL,
  `ITR_2551M_15E` varchar(100) NOT NULL,
  `ITR_2551M_16A` varchar(100) NOT NULL,
  `ITR_2551M_16B` varchar(100) NOT NULL,
  `ITR_2551M_16C` varchar(100) NOT NULL,
  `ITR_2551M_16D` varchar(100) NOT NULL,
  `ITR_2551M_16E` varchar(100) NOT NULL,
  `ITR_2551M_17A` varchar(100) NOT NULL,
  `ITR_2551M_17B` varchar(100) NOT NULL,
  `ITR_2551M_17C` varchar(100) NOT NULL,
  `ITR_2551M_17D` varchar(100) NOT NULL,
  `ITR_2551M_17E` varchar(100) NOT NULL,
  `ITR_2551M_18A` varchar(100) NOT NULL,
  `ITR_2551M_18B` varchar(100) NOT NULL,
  `ITR_2551M_18C` varchar(100) NOT NULL,
  `ITR_2551M_18D` varchar(100) NOT NULL,
  `ITR_2551M_18E` varchar(100) NOT NULL,
  `ITR_2551M_19` varchar(100) DEFAULT NULL,
  `ITR_2551M_20A` varchar(100) DEFAULT NULL,
  `ITR_2551M_20B` varchar(100) DEFAULT NULL,
  `ITR_2551M_21` varchar(100) DEFAULT NULL,
  `ITR_2551M_22` varchar(100) DEFAULT NULL,
  `ITR_2551M_23A` varchar(100) DEFAULT NULL,
  `ITR_2551M_23B` varchar(100) DEFAULT NULL,
  `ITR_2551M_23C` varchar(100) DEFAULT NULL,
  `ITR_2551M_23D` varchar(100) DEFAULT NULL,
  `ITR_2551M_24` varchar(100) DEFAULT NULL,
  `ITR_2551M_to_be_refunded` enum('yes','no') NOT NULL DEFAULT 'no',
  `ITR_2551M_to_be_issued` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `taxable_peroid_id` (`taxable_peroid_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_general_journal_entry`
--

CREATE TABLE IF NOT EXISTS `tbl_general_journal_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `general_journal_number` varchar(30) NOT NULL,
  `trans_date` date NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `amount` double NOT NULL,
  `date_created` date NOT NULL,
  `date_modified` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_general_journal_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_general_journal_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `general_journal_id` int(100) NOT NULL,
  `account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `debit` double NOT NULL,
  `credit` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `general_journal_id` (`general_journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_group`
--

CREATE TABLE IF NOT EXISTS `tbl_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(100) NOT NULL,
  `group_desc` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_invoice_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_invoice_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `all_invoice_id` int(11) NOT NULL,
  `sub_total_amount` double DEFAULT NULL,
  `vatable_sales` double NOT NULL,
  `vat_exempt` double NOT NULL,
  `non_vat` double NOT NULL,
  `zero_rated` double NOT NULL,
  `vat_amount` double DEFAULT NULL,
  `discount_amount` double NOT NULL,
  `discount_line_amount` double NOT NULL,
  `discount_peso_amount` double NOT NULL,
  `grand_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `all_invoice_id` (`all_invoice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_invoice_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_invoice_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_invoice_id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `description` varchar(100) NOT NULL,
  `particular` text NOT NULL,
  `vat_id` int(11) NOT NULL,
  `discount_line` double NOT NULL,
  `rate` double NOT NULL,
  `unit_cost` double NOT NULL,
  `hour` double DEFAULT NULL,
  `quantity` double DEFAULT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `task_id` (`task_id`),
  KEY `new_invoice_id` (`new_invoice_id`),
  KEY `vat_id` (`vat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_item`
--

CREATE TABLE IF NOT EXISTS `tbl_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `item_code` varchar(15) DEFAULT NULL,
  `Description` varchar(100) DEFAULT NULL,
  `unit_cost` double DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_journal_entry`
--

CREATE TABLE IF NOT EXISTS `tbl_journal_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `journal_number` varchar(30) NOT NULL,
  `trans_date` date NOT NULL,
  `remarks` text NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `amount` double NOT NULL,
  `date_created` date NOT NULL,
  `date_modified` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_journal_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_journal_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_entry_id` int(11) NOT NULL,
  `type` enum('HMO Partner','Patient','Supplier','GL Posting') NOT NULL,
  `account_code` varchar(100) NOT NULL,
  `particulars` text NOT NULL,
  `debit` double NOT NULL,
  `credit` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_entry_id` (`journal_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_liquidation_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_liquidation_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_liquidation_id` int(11) NOT NULL,
  `refund_amount` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `total_expenses` double NOT NULL,
  `input_vat` double NOT NULL,
  `total_amount` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `new_liquidation_id` (`new_liquidation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_liquidation_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_liquidation_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_liquidation_id` int(11) NOT NULL,
  `gl_posting` int(11) NOT NULL,
  `particular` varchar(100) NOT NULL,
  `vat_id` int(11) NOT NULL,
  `cost_center` enum('CFC','HOLD','SFC','ANCOP','GENERAL') NOT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `new_liquidation_id` (`new_liquidation_id`),
  KEY `gl_posting` (`gl_posting`),
  KEY `vat_id` (`vat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_mop`
--

CREATE TABLE IF NOT EXISTS `tbl_mop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `tbl_mop`
--

INSERT INTO `tbl_mop` (`id`, `code`, `description`) VALUES
(1, 'Cash', 'Cash'),
(2, 'Credit', 'Credit'),
(3, 'Check', 'Check'),
(4, 'Wire Transfer', 'Wire Transfer');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_cash_advance`
--

CREATE TABLE IF NOT EXISTS `tbl_new_cash_advance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `gl_posting` int(11) NOT NULL,
  `type_of_CA` enum('Officer Employee','For Liquidation') NOT NULL,
  `cash_advance_num` varchar(100) NOT NULL,
  `reference_number` varchar(11) DEFAULT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `particular` text,
  `status` enum('posted','open','reversed','pending','preapproved','approved','rejected','cancelled','pending_reverse','preapproved_reverse','approved_reverse') DEFAULT NULL,
  `reversed_remarks` text NOT NULL,
  `rejected_remarks` text NOT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  `modified_by` varchar(100) NOT NULL,
  `preapproved_by` varchar(100) NOT NULL,
  `approved_by` varchar(100) NOT NULL,
  `posted_by` enum('yes','no') NOT NULL,
  `received_by` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `supplier_id_2` (`supplier_id`),
  KEY `gl_posting` (`gl_posting`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_cash_invoice`
--

CREATE TABLE IF NOT EXISTS `tbl_new_cash_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `php_rate` varchar(100) NOT NULL,
  `client_account` varchar(100) DEFAULT NULL,
  `send_by_email` enum('yes','no') NOT NULL,
  `inclusive_of_vat` enum('yes','no') NOT NULL DEFAULT 'yes',
  `invoice_for` enum('task','item','both','') NOT NULL,
  `invoice_number` varchar(100) DEFAULT NULL,
  `or_num` varchar(100) NOT NULL,
  `cas_no` varchar(100) NOT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `PO_SO` varchar(100) DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `particular` text,
  `remarks` text,
  `status` enum('posted','open','reversed','cancelled') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `currency_id` (`currency_id`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_expense`
--

CREATE TABLE IF NOT EXISTS `tbl_new_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) DEFAULT NULL,
  `gl_posting` int(11) NOT NULL,
  `expense_number` varchar(100) NOT NULL,
  `reference_number` varchar(11) DEFAULT NULL,
  `currency_id` int(11) NOT NULL,
  `php_rate` varchar(100) NOT NULL,
  `inclusive_of_vat` enum('yes','no','','') NOT NULL,
  `include_input_tax` enum('yes','no') NOT NULL,
  `ewt` enum('0','5','10','15') NOT NULL,
  `discount` double DEFAULT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `particular` text,
  `status` enum('posted','open','reversed','cancelled') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_lines_id` (`reference_number`),
  KEY `expense_number` (`expense_number`),
  KEY `currency_id` (`currency_id`),
  KEY `gl_posting` (`gl_posting`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_invoice`
--

CREATE TABLE IF NOT EXISTS `tbl_new_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `project_id` int(11) NOT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `php_rate` varchar(100) DEFAULT NULL,
  `client_account` varchar(100) DEFAULT NULL,
  `send_by_email` enum('yes','no') DEFAULT NULL,
  `inclusive_of_vat` enum('yes','no') NOT NULL DEFAULT 'yes',
  `invoice_for` enum('task','item','both','') NOT NULL,
  `invoice_number` varchar(100) DEFAULT NULL,
  `or_num` varchar(100) NOT NULL,
  `cas_no` varchar(100) NOT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `PO_SO` varchar(100) DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `particular` text,
  `remarks` text,
  `status` enum('posted','open','reversed','cancelled') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `currency_id` (`currency_id`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_liquidation`
--

CREATE TABLE IF NOT EXISTS `tbl_new_liquidation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_cash_advance_id` int(11) NOT NULL,
  `gl_posting` int(11) NOT NULL,
  `liquidation_num` varchar(100) NOT NULL,
  `reference_number` varchar(11) DEFAULT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `particular` text,
  `pr_num` varchar(100) NOT NULL,
  `waive` enum('yes','no') NOT NULL,
  `status` enum('posted','open','reversed','pending','preapproved','approved','rejected','cancelled') DEFAULT NULL,
  `reversed_remarks` text NOT NULL,
  `rejected_remarks` text NOT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  `modified_by` varchar(100) NOT NULL,
  `preapproved_by` varchar(100) NOT NULL,
  `approved_by` varchar(100) NOT NULL,
  `posted_by` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`new_cash_advance_id`),
  KEY `supplier_id_2` (`new_cash_advance_id`),
  KEY `gl_posting` (`gl_posting`),
  KEY `new_cash_advance_id` (`new_cash_advance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_payable`
--

CREATE TABLE IF NOT EXISTS `tbl_new_payable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `gl_posting` int(11) NOT NULL,
  `php_rate` varchar(100) DEFAULT NULL,
  `send_by_email` enum('yes','no') DEFAULT NULL,
  `inclusive_of_vat` enum('yes','no') NOT NULL DEFAULT 'yes',
  `include_input_tax` varchar(150) NOT NULL,
  `payable_number` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `ref_num` varchar(100) NOT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` enum('posted','open','reversed') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `currency_id` (`currency_id`),
  KEY `gl_posting` (`gl_posting`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_new_pc_replenishment`
--

CREATE TABLE IF NOT EXISTS `tbl_new_pc_replenishment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `gl_posting` int(11) NOT NULL,
  `php_rate` varchar(100) DEFAULT NULL,
  `send_by_email` enum('yes','no') DEFAULT NULL,
  `inclusive_of_vat` enum('yes','no') NOT NULL DEFAULT 'yes',
  `include_input_tax` varchar(150) NOT NULL,
  `pettycash_number` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `ref_num` varchar(100) NOT NULL,
  `date_issued` date DEFAULT NULL,
  `date_reversed` date NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` enum('posted','open','reversed') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `currency_id` (`currency_id`),
  KEY `gl_posting` (`gl_posting`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
--
-- Table structure for table `tbl_new_recurring`
--

CREATE TABLE IF NOT EXISTS `tbl_new_recurring` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT NULL,
  `currency_id` int(11) NOT NULL,
  `rate` double NOT NULL,
  `client_account` varchar(100) DEFAULT NULL,
  `send_by_email` enum('yes','no') NOT NULL,
  `recurring_number` varchar(100) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `PO_SO` varchar(100) DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `particular` text,
  `remarks` text,
  `status` enum('saved','stop') DEFAULT NULL,
  `frequency` enum('weekly','monthly') NOT NULL,
  `total_amount_line` double NOT NULL,
  `last_date_sent` date NOT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `recurring_number` (`recurring_number`),
  KEY `client_id` (`client_id`),
  KEY `currency_id` (`currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_organization`
--

CREATE TABLE IF NOT EXISTS `tbl_organization` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_account` varchar(30) DEFAULT NULL,
  `org_name` varchar(100) DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_organization_info`
--

CREATE TABLE IF NOT EXISTS `tbl_organization_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `org_account` varchar(30) DEFAULT NULL,
  `address` text,
  `tin_num` varchar(100) DEFAULT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `secretary_email` varchar(100) NOT NULL,
  `accountant_email` varchar(100) NOT NULL,
  `phone_num` varchar(30) DEFAULT NULL,
  `fax_num` varchar(30) DEFAULT NULL,
  `rdo_code` varchar(100) DEFAULT NULL,
  `zip_code` varchar(100) DEFAULT NULL,
  `line_of_business` varchar(100) DEFAULT NULL,
  `mode_of_payment` enum('itemized','osd') DEFAULT NULL,
  `top_tax_payer` enum('yes','no') NOT NULL,
  `type_of_tax` enum('vat','percentage') DEFAULT NULL,
  `wht_tax` enum('0','1%','2%','5%','10%','15%') NOT NULL,
  `logo_name` text,
  `logo` BLOB NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_payable_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_payable_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_payable_id` int(11) NOT NULL,
  `sub_total_amount` double DEFAULT NULL,
  `vatable_amount` double NOT NULL,
  `exempt_amount` double NOT NULL,
  `zero_rated_amount` double NOT NULL,
  `non_vat_amount` double NOT NULL,
  `vat_amount` double DEFAULT NULL,
  `ewt_amount` double NOT NULL,
  `grand_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `new_payable_id` (`new_payable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_payable_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_payable_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_payable_id` int(11) NOT NULL,
  `coa_id` int(11) NOT NULL,
  `description` varchar(100) NOT NULL,
  `vat_id` int(11) NOT NULL,
  `wht` enum('0','1','2','5','10','15') NOT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `new_payable_id` (`new_payable_id`),
  KEY `coa_id` (`coa_id`),
  KEY `vat_id` (`vat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_payment_terms`
--

CREATE TABLE IF NOT EXISTS `tbl_payment_terms` (
  `id` int(11) NOT NULL DEFAULT '0',
  `org_id` int(11) DEFAULT NULL,
  `payment_code` varchar(30) DEFAULT NULL,
  `description` text,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_pc_replenishment_amount`
--

CREATE TABLE IF NOT EXISTS `tbl_pc_replenishment_amount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_pettycash_id` int(11) NOT NULL,
  `sub_total_amount` double DEFAULT NULL,
  `vatable_amount` double NOT NULL,
  `exempt_amount` double NOT NULL,
  `zero_rated_amount` double NOT NULL,
  `non_vat_amount` double NOT NULL,
  `vat_amount` double DEFAULT NULL,
  `ewt_amount` double NOT NULL,
  `grand_total` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `new_pettycash_id` (`new_pettycash_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_pc_replenishment_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_pc_replenishment_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_pettycash_id` int(11) NOT NULL,
  `coa_id` int(11) NOT NULL,
  `description` varchar(100) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `vat_id` int(11) NOT NULL,
  `wht` enum('0','1','2','5','10','15') NOT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `coa_id` (`coa_id`),
  KEY `vat_id` (`vat_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `new_pettycash_id` (`new_pettycash_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
--
-- Table structure for table `tbl_project`
--

CREATE TABLE IF NOT EXISTS `tbl_project` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_num` varchar(30) DEFAULT NULL,
  `project_name` varchar(100) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `dept_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `cost_center_id` int(11) NOT NULL,
  `status` enum('In Process','Finished') NOT NULL,
  `start_date` date NOT NULL,
  `estimated_end` date NOT NULL,
  `budget_hours` varchar(100) NOT NULL,
  `referred_by` int(11) NOT NULL,
  `initiated_by` int(11) NOT NULL,
  `closed_by` int(11) NOT NULL,
  `manage_by` int(11) NOT NULL,
  `active_account` enum('yes','no') DEFAULT NULL,
  `trans_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `dept_id` (`dept_id`,`group_id`,`cost_center_id`,`referred_by`,`initiated_by`,`closed_by`,`manage_by`),
  KEY `group_id` (`group_id`),
  KEY `cost_center_id` (`cost_center_id`),
  KEY `manage_by` (`manage_by`),
  KEY `closed_by` (`closed_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_purchase_journal_entry`
--

CREATE TABLE IF NOT EXISTS `tbl_purchase_journal_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `purchase_journal_number` varchar(30) NOT NULL,
  `trans_date` date NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `amount` double NOT NULL,
  `date_created` date NOT NULL,
  `date_modified` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_purchase_journal_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_purchase_journal_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_journal_id` int(11) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `gl_posting` int(11) NOT NULL,
  `remarks` varchar(100) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `amount_purchase` double NOT NULL,
  `total_amount` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `purchase_journal_id` (`purchase_journal_id`) USING BTREE,
  KEY `gl_posting` (`gl_posting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_rdo`
--

CREATE TABLE IF NOT EXISTS `tbl_rdo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `address` varchar(100) NOT NULL,
  `email_address` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=127 ;

--
-- Dumping data for table `tbl_rdo`
--

INSERT INTO `tbl_rdo` (`id`, `code`, `address`, `email_address`) VALUES
(1, '001', 'Laoag City, Ilocos Norte', ''),
(2, '002', 'Vigan, Ilocos Sur', ''),
(3, '003', 'San Fernando, La Union', ''),
(4, '004', 'Calasiao, West Pangasinan', ''),
(5, '005', 'Alaminos, West Pangasinan', ''),
(6, '006', 'Urdaneta, East Pangasinan', ''),
(7, '007', 'Bangued, Abra', ''),
(8, '008', 'Baguio City', ''),
(9, '009', 'La Trinidad, Benguet', ''),
(10, '010', 'Bontoc, Mt. Province', ''),
(11, '011', 'Tabuk, Kalinga-Apayao', ''),
(12, '012', 'Lagawe, Ifugao', ''),
(13, '013', 'Tuguegarao, Cagayan', ''),
(14, '014', 'Bayombong, Nueva Vizcaya', ''),
(15, '015', 'Iligan, Isabela', ''),
(16, '016', 'Cabarroguis, Quirino', ''),
(17, '17A', 'Tarlac, Tarlac', ''),
(18, '17B', 'Paniqui, Tarlac', ''),
(19, '018', 'Olongapo City', ''),
(20, '019', 'Subic Bay Metropolitan Authority', ''),
(21, '020', 'Balanga, Bataan', ''),
(22, '21A', 'North Pampanga', ''),
(23, '21B', 'South Pampanga Cabanatuan City', ''),
(24, '022', 'Baler, Aurora', ''),
(25, '23A', 'North Nueva Ecija', ''),
(26, '23B', 'South Nueva Ecija Malabon-Navotas', ''),
(27, '024', 'Valenzuela City', ''),
(28, '25A', 'Plaridel, Bulacan', ''),
(29, '25B', 'Marilau, Bulacan', ''),
(30, '026', 'Malabon-Navotas', ''),
(31, '027', 'Caloocan City', ''),
(32, '028', 'Novaliches', ''),
(33, '029', 'San Nicolas, Tondo', ''),
(34, '030', 'Binondo', ''),
(35, '031', 'Sta. Cruz', ''),
(36, '032', 'Quiapo-Sampaloc-San Miguel', ''),
(37, '033', 'Intramuros-Ermita-Malate', ''),
(38, '034', 'Paco-Pandacan-Sta. Ana', ''),
(39, '035', 'Romblon', ''),
(40, '036', 'Puerto Princesa', ''),
(41, '037', 'San Jose, Occidental Mindoro', ''),
(42, '038', 'North, Quezon City', ''),
(43, '039', 'South, Quezon City', ''),
(44, '040', 'Cubao', ''),
(45, '041', 'Mandaluyong', ''),
(46, '042', 'San Juan', ''),
(47, '43A', 'East Pasig', ''),
(48, '43B', 'West Pasig', ''),
(49, '044', 'Taguig-Pateros', ''),
(50, '045', 'Marikina', ''),
(51, '046', 'Cainta-Taytay', ''),
(52, '047', 'East Makati', ''),
(53, '048', 'West Makati', ''),
(54, '049', 'North Makati', ''),
(55, '050', 'South Makati', ''),
(56, '051', 'Pasay City', ''),
(57, '052', 'Paranaque', ''),
(58, '53A', 'Las Pinas City', ''),
(59, '53B', 'Muntinlupa City', ''),
(60, '54A', 'Trece Martirez City, South Cavite', ''),
(61, '54B', 'Rosario, North Cavite', ''),
(62, '055', 'San Pablo City', ''),
(63, '056', 'Calamba, Laguna', ''),
(64, '057', 'San Pedro, Laguna', ''),
(65, '058', 'Batangas City', ''),
(66, '059', 'Lipa City', ''),
(67, '060', 'Lucena City', ''),
(68, '061', 'Gumaca, Quezon', ''),
(69, '062', 'Boac, Marinduque', ''),
(70, '063', 'Calapan, Oriental Mindoro', ''),
(71, '064', 'Daet, Camarines Norte', ''),
(72, '065', 'Naga City', ''),
(73, '066', 'Iriga City', ''),
(74, '067', 'Legaspi City', ''),
(75, '068', 'Sorsogon, Sorsogon', ''),
(76, '069', 'Virac, Catanduanes', ''),
(77, '070', 'Masbate, Masbate', ''),
(78, '071', 'Kalibo, Aklan', ''),
(79, '072', 'Roxas City', ''),
(80, '073', 'San Jose, Antique', ''),
(81, '074', 'Iloilo City', ''),
(82, '075', 'Zarraga, Iloilo City', ''),
(83, '076', 'Victorias, Northern Negros Occ.', ''),
(84, '077', 'Bacolod City', ''),
(85, '078', 'Binalbagan, Negros Occidental', ''),
(86, '079', 'Dumaguete City', ''),
(87, '080', 'Mandaue City', ''),
(88, '081', 'Cebu City North', ''),
(89, '082', 'Cebu City South', ''),
(90, '083', 'Talisay Cebu', ''),
(91, '084', 'Tagbilaran City', ''),
(92, '085', 'Catarman, Northern Samar', ''),
(93, '086', 'Borongan, Eastern Samar', ''),
(94, '087', 'Catbalogan, Western', ''),
(95, '088', 'Tacloban City', ''),
(96, '089', 'Ormoc City', ''),
(97, '090', 'Maasin, Southern Leyte', ''),
(98, '091', 'Dipolog City', ''),
(99, '092', 'Pagadian City, Zamboanga del Sur', ''),
(100, '93A', 'Zamboanga City', ''),
(101, '93B', 'Zamboanga Sibugay', ''),
(102, '094', 'Isabela, Basilan', ''),
(103, '095', 'Jolo, Sulu', ''),
(104, '096', 'Bongao, Tawi-Tawi', ''),
(105, '097', 'Gingoog City', ''),
(106, '098', 'Cagayan de Oro City', ''),
(107, '099', 'Malabalay, Bukidnon', ''),
(108, '100', 'Ozamis City', ''),
(109, '101', 'Illigan City', ''),
(110, '102', 'Marawi City', ''),
(111, '103', 'Butuan City', ''),
(112, '104', 'Bayugan, Agusan del Sur', ''),
(113, '105', 'Surigao City', ''),
(114, '106', 'Tandag, Surigao del Sur', ''),
(115, '107', 'Cotabato City', ''),
(116, '108', 'Kidapawan, North Cotabato', ''),
(117, '109', 'Tacurong, Sultan Kudarat', ''),
(118, '110', 'General Santos City', ''),
(119, '111', 'Koronadal, South Cotabato', ''),
(120, '112', 'Tagum, Davao del Norte', ''),
(121, '113', 'West Davao City', ''),
(122, '113', 'East Davao City', ''),
(123, '114', 'Mati, Davao Oriental', ''),
(124, '115', 'Digos, Davao del Sur', ''),
(125, '122', 'Makati Large Taxpayers District Office', ''),
(126, '123', 'Cebu Large Taxpayers District Office', '');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_recurring_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_recurring_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `new_recurring_id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `item_description` varchar(100) NOT NULL,
  `task_description` varchar(100) NOT NULL,
  `rate` double NOT NULL,
  `unit_cost` double NOT NULL,
  `hour` double DEFAULT NULL,
  `quantity` double DEFAULT NULL,
  `net_amount` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `task_id` (`task_id`),
  KEY `new_invoice_id` (`new_recurring_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_referral`
--

CREATE TABLE IF NOT EXISTS `tbl_referral` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name_of_friend` varchar(100) NOT NULL,
  `email_of_friend` varchar(100) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_sales_journal_entry`
--

CREATE TABLE IF NOT EXISTS `tbl_sales_journal_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `sales_journal_number` varchar(30) NOT NULL,
  `trans_date` date NOT NULL,
  `status` enum('posted','open') NOT NULL,
  `amount` double NOT NULL,
  `date_created` date NOT NULL,
  `date_modified` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_sales_journal_lines`
--

CREATE TABLE IF NOT EXISTS `tbl_sales_journal_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_journal_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `remarks` varchar(100) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `amount` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_journal_id` (`sales_journal_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_supplier`
--

CREATE TABLE IF NOT EXISTS `tbl_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `supplier_account` varchar(30) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `type` enum('General Vendor','Professional','General Professional Partnership','Employee') NOT NULL,
  `category` enum('supplier','employee') NOT NULL,
  `address` text,
  `tin` varchar(100) NOT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `phone_num` varchar(30) DEFAULT NULL,
  `fax_num` varchar(30) DEFAULT NULL,
  `prof_sub` enum('yes','no') NOT NULL,
  `gross_income` enum('>720,00','<720,00') NOT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `date_created` date NOT NULL,
  `active_account` enum('yes','no') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `currency_id` (`currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_support`
--

CREATE TABLE IF NOT EXISTS `tbl_support` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `status` enum('open','fixed') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_task`
--

CREATE TABLE IF NOT EXISTS `tbl_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `task_code` varchar(15) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `particular` text NOT NULL,
  `rate_per_hour` double DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_tax`
--

CREATE TABLE IF NOT EXISTS `tbl_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_code` varchar(15) DEFAULT NULL,
  `description` text,
  `rate` double DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `tbl_tax`
--

INSERT INTO `tbl_tax` (`id`, `tax_code`, `description`, `rate`, `active`, `date_created`, `date_modified`) VALUES
(1, 'Vatable', 'Vatable', 12, 'yes', '2015-01-22', '2015-01-22'),
(2, 'Vat-Exempt', 'Vat-Exempt', 0, 'yes', '2015-01-22', '2015-01-22'),
(3, 'Non-Vat', 'Non-Vat', 0, 'yes', '2015-01-22', '2015-01-22'),
(4, 'Zero Rated', 'Zero Rated', 0, 'yes', '2015-01-22', '2015-01-22');

-- --------------------------------------------------------

--
-- Table structure for table `tbl_taxable_period`
--

CREATE TABLE IF NOT EXISTS `tbl_taxable_period` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `month` enum('january','february','march','april','may','june','july','august','september','october','november','december') NOT NULL,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_tax_filed_monitoring`
--

CREATE TABLE IF NOT EXISTS `tbl_tax_filed_monitoring` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `trans_date` date NOT NULL,
  `itr` int(11) NOT NULL,
  `itr_code` enum('Form 2550M','Form 2550Q','Form 2551M','Form 1601E','Form 1601C','Form 1701','Form 1701Q','Form 0605','Form 2307','Form 1604E') NOT NULL,
  `final` enum('yes','no') NOT NULL,
  `submitted` enum('yes','no') NOT NULL,
  `date_filed` date NOT NULL,
  `check_num` int(11) NOT NULL,
  `Amount` double NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_terms`
--

CREATE TABLE IF NOT EXISTS `tbl_terms` (
  `id` int(11) NOT NULL DEFAULT '0',
  `org_id` int(11) DEFAULT NULL,
  `code` varchar(15) DEFAULT NULL,
  `description` text,
  `days_to_due_date` date DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_time_tracking`
--

CREATE TABLE IF NOT EXISTS `tbl_time_tracking` (
  `id` int(11) NOT NULL DEFAULT '0',
  `trans_date` date DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `hour` double DEFAULT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `status` enum('billed','unbilled') DEFAULT NULL,
  `note` text,
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_trial_balance`
--

CREATE TABLE IF NOT EXISTS `tbl_trial_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coa_id` int(11) NOT NULL,
  `debit` double NOT NULL,
  `credit` double NOT NULL,
  `balance` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coa_id` (`coa_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_trial_balance_trans`
--

CREATE TABLE IF NOT EXISTS `tbl_trial_balance_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trial_balance_id` int(11) NOT NULL,
  `user_id` varchar(100) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `date` date NOT NULL,
  `type_of_transaction` enum('invoice','expense','collection','journal','payment','payable','receipt','cash advance','liquidation','petty cash') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `trial_balance_id` (`trial_balance_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user`
--

CREATE TABLE IF NOT EXISTS `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_info_id` int(11) NOT NULL,
  `user_no` varchar(100) NOT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `type` enum('admin','staff') DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  `date_created` date DEFAULT NULL,
  `date_modified` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_info_id` (`org_info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_users_log`
--

CREATE TABLE IF NOT EXISTS `tbl_users_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_time` datetime NOT NULL,
  `type_of_transaction` enum('Cash Receipt','Billing','Collection','Client','Service Item','Expense','Quick Expenses','Vendor','Journal Entry','User') NOT NULL,
  `action` enum('Added','Edited','Deleted','Saved','Posted','Reversed','Import','Export','Logs') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_access`
--

CREATE TABLE IF NOT EXISTS `tbl_user_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_level_id` int(11) NOT NULL,
  `_add` enum('yes','no') NOT NULL,
  `_edit` enum('yes','no') NOT NULL,
  `_delete` enum('yes','no') NOT NULL,
  `pre_approved` enum('yes','no') NOT NULL,
  `approved` enum('yes','no') NOT NULL,
  `post` enum('yes','no') NOT NULL,
  `reversed` enum('yes','no') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_level_id` (`user_level_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_level`
--

CREATE TABLE IF NOT EXISTS `tbl_user_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `invoice_module` enum('yes','no') NOT NULL,
  `cash_receipt` enum('yes','no') NOT NULL,
  `billing` enum('yes','no') NOT NULL,
  `collections` enum('yes','no') NOT NULL,
  `client` enum('yes','no') NOT NULL,
  `service_item` enum('yes','no') NOT NULL,
  `expenses_module` enum('yes','no') NOT NULL,
  `expense` enum('yes','no') NOT NULL,
  `quick_expense` enum('yes','no') NOT NULL,
  `vendor` enum('yes','no') NOT NULL,
  `accounting_module` enum('yes','no') NOT NULL,
  `COA` enum('yes','no') NOT NULL,
  `journal_entry` enum('yes','no') NOT NULL,
  `tax_plan_module` enum('yes','no') NOT NULL,
  `forecasted` enum('yes','no') NOT NULL,
  `current` enum('yes','no') NOT NULL,
  `tax_calendar` enum('yes','no') NOT NULL,
  `reports` enum('yes','no') NOT NULL,
  `FS` enum('yes','no') NOT NULL,
  `AR` enum('yes','no') NOT NULL,
  `sales` enum('yes','no') NOT NULL,
  `_OR` enum('yes','no') NOT NULL,
  `BIR` enum('yes','no') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tbl_user_login`
--

CREATE TABLE IF NOT EXISTS `tbl_user_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `status` enum('in','out') NOT NULL,
  `trans_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `tbl_all_bill_payable`
--
ALTER TABLE `tbl_all_bill_payable`
  ADD CONSTRAINT `tbl_all_bill_payable_ibfk_1` FOREIGN KEY (`enter_bill_payment_id`) REFERENCES `tbl_enter_bill_payment` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_all_cash_invoice`
--
ALTER TABLE `tbl_all_cash_invoice`
  ADD CONSTRAINT `tbl_all_cash_invoice_ibfk_1` FOREIGN KEY (`new_cash_invoice_id`) REFERENCES `tbl_new_cash_invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_all_collection`
--
ALTER TABLE `tbl_all_collection`
  ADD CONSTRAINT `tbl_all_collection_ibfk_1` FOREIGN KEY (`enter_payment_id`) REFERENCES `tbl_enter_payment` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_all_invoice`
--
ALTER TABLE `tbl_all_invoice`
  ADD CONSTRAINT `tbl_all_invoice_ibfk_1` FOREIGN KEY (`new_invoice_id`) REFERENCES `tbl_new_invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_atc_1601e`
--
ALTER TABLE `tbl_atc_1601e`
  ADD CONSTRAINT `tbl_atc_1601e_ibfk_1` FOREIGN KEY (`form_1601e_id`) REFERENCES `tbl_form_1601e` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_atp`
--
ALTER TABLE `tbl_atp`
  ADD CONSTRAINT `tbl_atp_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_cash_advance_amount`
--
ALTER TABLE `tbl_cash_advance_amount`
  ADD CONSTRAINT `tbl_cash_advance_amount_ibfk_1` FOREIGN KEY (`new_cash_advance_id`) REFERENCES `tbl_new_cash_advance` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_cash_advance_lines`
--
ALTER TABLE `tbl_cash_advance_lines`
  ADD CONSTRAINT `tbl_cash_advance_lines_ibfk_1` FOREIGN KEY (`new_cash_advance_id`) REFERENCES `tbl_new_cash_advance` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_cash_invoice_amount`
--
ALTER TABLE `tbl_cash_invoice_amount`
  ADD CONSTRAINT `tbl_cash_invoice_amount_ibfk_1` FOREIGN KEY (`all_cash_invoice_id`) REFERENCES `tbl_all_cash_invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_cash_invoice_lines`
--
ALTER TABLE `tbl_cash_invoice_lines`
  ADD CONSTRAINT `tbl_cash_invoice_lines_ibfk_1` FOREIGN KEY (`new_cash_invoice_id`) REFERENCES `tbl_new_cash_invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_cash_invoice_lines_ibfk_2` FOREIGN KEY (`task_id`) REFERENCES `tbl_task` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_cash_invoice_lines_ibfk_3` FOREIGN KEY (`vat_id`) REFERENCES `tbl_tax` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_client`
--
ALTER TABLE `tbl_client`
  ADD CONSTRAINT `tbl_client_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_coa`
--
ALTER TABLE `tbl_coa`
  ADD CONSTRAINT `tbl_coa_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_comment`
--
ALTER TABLE `tbl_comment`
  ADD CONSTRAINT `tbl_comment_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_employee`
--
ALTER TABLE `tbl_employee`
  ADD CONSTRAINT `tbl_employee_ibfk_1` FOREIGN KEY (`emp_group`) REFERENCES `tbl_group` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_employee_ibfk_2` FOREIGN KEY (`emp_costc`) REFERENCES `tbl_cost_center` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_employee_ibfk_3` FOREIGN KEY (`emp_dept`) REFERENCES `tbl_department` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_enter_bill_payment`
--
ALTER TABLE `tbl_enter_bill_payment`
  ADD CONSTRAINT `tbl_enter_bill_payment_ibfk_1` FOREIGN KEY (`gl_posting`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_enter_payment`
--
ALTER TABLE `tbl_enter_payment`
  ADD CONSTRAINT `tbl_enter_payment_ibfk_1` FOREIGN KEY (`mop_id`) REFERENCES `tbl_mop` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_enter_payment_ibfk_2` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_expense_amount`
--
ALTER TABLE `tbl_expense_amount`
  ADD CONSTRAINT `tbl_expense_amount_ibfk_1` FOREIGN KEY (`new_expense_id`) REFERENCES `tbl_new_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_expense_lines`
--
ALTER TABLE `tbl_expense_lines`
  ADD CONSTRAINT `tbl_expense_lines_ibfk_2` FOREIGN KEY (`new_expense_id`) REFERENCES `tbl_new_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_expense_lines_ibfk_3` FOREIGN KEY (`vat_id`) REFERENCES `tbl_tax` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_expense_lines_ibfk_4` FOREIGN KEY (`coa_id`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_0605`
--
ALTER TABLE `tbl_form_0605`
  ADD CONSTRAINT `tbl_form_0605_ibfk_1` FOREIGN KEY (`taxable_period_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1601c`
--
ALTER TABLE `tbl_form_1601c`
  ADD CONSTRAINT `tbl_form_1601c_ibfk_1` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1601e`
--
ALTER TABLE `tbl_form_1601e`
  ADD CONSTRAINT `tbl_form_1601e_ibfk_1` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701`
--
ALTER TABLE `tbl_form_1701`
  ADD CONSTRAINT `tbl_form_1701_ibfk_1` FOREIGN KEY (`taxable_period_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701q`
--
ALTER TABLE `tbl_form_1701q`
  ADD CONSTRAINT `tbl_form_1701q_ibfk_1` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_old`
--
ALTER TABLE `tbl_form_1701_old`
  ADD CONSTRAINT `tbl_form_1701_old_ibfk_1` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_1`
--
ALTER TABLE `tbl_form_1701_page_1`
  ADD CONSTRAINT `tbl_form_1701_page_1_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_2`
--
ALTER TABLE `tbl_form_1701_page_2`
  ADD CONSTRAINT `tbl_form_1701_page_2_ibfk_1` FOREIGN KEY (`form_1701_1d`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_3`
--
ALTER TABLE `tbl_form_1701_page_3`
  ADD CONSTRAINT `tbl_form_1701_page_3_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_4`
--
ALTER TABLE `tbl_form_1701_page_4`
  ADD CONSTRAINT `tbl_form_1701_page_4_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_5`
--
ALTER TABLE `tbl_form_1701_page_5`
  ADD CONSTRAINT `tbl_form_1701_page_5_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_6`
--
ALTER TABLE `tbl_form_1701_page_6`
  ADD CONSTRAINT `tbl_form_1701_page_6_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_7`
--
ALTER TABLE `tbl_form_1701_page_7`
  ADD CONSTRAINT `tbl_form_1701_page_7_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_8`
--
ALTER TABLE `tbl_form_1701_page_8`
  ADD CONSTRAINT `tbl_form_1701_page_8_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_9`
--
ALTER TABLE `tbl_form_1701_page_9`
  ADD CONSTRAINT `tbl_form_1701_page_9_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_10`
--
ALTER TABLE `tbl_form_1701_page_10`
  ADD CONSTRAINT `tbl_form_1701_page_10_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_11`
--
ALTER TABLE `tbl_form_1701_page_11`
  ADD CONSTRAINT `tbl_form_1701_page_11_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_1701_page_12`
--
ALTER TABLE `tbl_form_1701_page_12`
  ADD CONSTRAINT `tbl_form_1701_page_12_ibfk_1` FOREIGN KEY (`form_1701_id`) REFERENCES `tbl_form_1701` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_2307`
--
ALTER TABLE `tbl_form_2307`
  ADD CONSTRAINT `tbl_form_2307_ibfk_1` FOREIGN KEY (`taxable_period_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_2307_part_2`
--
ALTER TABLE `tbl_form_2307_part_2`
  ADD CONSTRAINT `tbl_form_2307_part_2_ibfk_1` FOREIGN KEY (`form_2307_id`) REFERENCES `tbl_form_2307` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_2550m`
--
ALTER TABLE `tbl_form_2550m`
  ADD CONSTRAINT `tbl_form_2550m_ibfk_1` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_2550q`
--
ALTER TABLE `tbl_form_2550q`
  ADD CONSTRAINT `tbl_form_2550q_ibfk_1` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_form_2551m`
--
ALTER TABLE `tbl_form_2551m`
  ADD CONSTRAINT `tbl_form_2551m_ibfk_3` FOREIGN KEY (`taxable_peroid_id`) REFERENCES `tbl_taxable_period` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_general_journal_entry`
--
ALTER TABLE `tbl_general_journal_entry`
  ADD CONSTRAINT `tbl_general_journal_entry_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_general_journal_lines`
--
ALTER TABLE `tbl_general_journal_lines`
  ADD CONSTRAINT `tbl_general_journal_lines_ibfk_1` FOREIGN KEY (`general_journal_id`) REFERENCES `tbl_general_journal_entry` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_general_journal_lines_ibfk_2` FOREIGN KEY (`account_id`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_invoice_amount`
--
ALTER TABLE `tbl_invoice_amount`
  ADD CONSTRAINT `tbl_invoice_amount_ibfk_1` FOREIGN KEY (`all_invoice_id`) REFERENCES `tbl_all_invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_invoice_lines`
--
ALTER TABLE `tbl_invoice_lines`
  ADD CONSTRAINT `tbl_invoice_lines_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tbl_task` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_invoice_lines_ibfk_3` FOREIGN KEY (`new_invoice_id`) REFERENCES `tbl_new_invoice` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_invoice_lines_ibfk_4` FOREIGN KEY (`vat_id`) REFERENCES `tbl_tax` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_journal_entry`
--
ALTER TABLE `tbl_journal_entry`
  ADD CONSTRAINT `tbl_journal_entry_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_journal_lines`
--
ALTER TABLE `tbl_journal_lines`
  ADD CONSTRAINT `tbl_journal_lines_ibfk_1` FOREIGN KEY (`journal_entry_id`) REFERENCES `tbl_journal_entry` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_liquidation_lines`
--
ALTER TABLE `tbl_liquidation_lines`
  ADD CONSTRAINT `tbl_liquidations_line_fk1` FOREIGN KEY (`vat_id`) REFERENCES `tbl_tax` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_new_cash_advance`
--
ALTER TABLE `tbl_new_cash_advance`
  ADD CONSTRAINT `tbl_new_cash_advance_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `tbl_supplier` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_new_cash_advance_ibfk_2` FOREIGN KEY (`gl_posting`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_new_cash_invoice`
--
ALTER TABLE `tbl_new_cash_invoice`
  ADD CONSTRAINT `tbl_new_cash_invoice_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_new_cash_invoice_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `tbl_project` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_new_expense`
--
ALTER TABLE `tbl_new_expense`
  ADD CONSTRAINT `tbl_new_expense_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `tbl_supplier` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_new_expense_ibfk_4` FOREIGN KEY (`gl_posting`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_new_invoice`
--
ALTER TABLE `tbl_new_invoice`
  ADD CONSTRAINT `tbl_new_invoice_ibfk_1` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_new_invoice_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `tbl_project` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_new_liquidation`
--
ALTER TABLE `tbl_new_liquidation`
  ADD CONSTRAINT `tbl_new_liquidation_ibfk_2` FOREIGN KEY (`gl_posting`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_new_liquidation_ibfk_3` FOREIGN KEY (`new_cash_advance_id`) REFERENCES `tbl_new_cash_advance` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_new_payable`
--
ALTER TABLE `tbl_new_payable`
  ADD CONSTRAINT `FK_tbl_new_payable_tbl_coa` FOREIGN KEY (`gl_posting`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_new_payable_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `tbl_supplier` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_organization_info`
--
ALTER TABLE `tbl_organization_info`
  ADD CONSTRAINT `tbl_organization_info_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_payable_amount`
--
ALTER TABLE `tbl_payable_amount`
  ADD CONSTRAINT `tbl_payable_amount_ibfk_1` FOREIGN KEY (`new_payable_id`) REFERENCES `tbl_new_payable` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_payable_lines`
--
ALTER TABLE `tbl_payable_lines`
  ADD CONSTRAINT `tbl_payable_lines_ibfk_1` FOREIGN KEY (`new_payable_id`) REFERENCES `tbl_new_payable` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_payable_lines_ibfk_2` FOREIGN KEY (`coa_id`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_project`
--
ALTER TABLE `tbl_project`
  ADD CONSTRAINT `tbl_project_ibfk_5` FOREIGN KEY (`client_id`) REFERENCES `tbl_client` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_purchase_journal_lines`
--
ALTER TABLE `tbl_purchase_journal_lines`
  ADD CONSTRAINT `tbl_purchase_journal_lines_ibfk_1` FOREIGN KEY (`purchase_journal_id`) REFERENCES `tbl_purchase_journal_entry` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_purchase_journal_lines_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `tbl_supplier` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tbl_purchase_journal_lines_ibfk_3` FOREIGN KEY (`gl_posting`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_recurring_lines`
--
ALTER TABLE `tbl_recurring_lines`
  ADD CONSTRAINT `tbl_recurring_lines_ibfk_1` FOREIGN KEY (`new_recurring_id`) REFERENCES `tbl_new_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_referral`
--
ALTER TABLE `tbl_referral`
  ADD CONSTRAINT `tbl_referral_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_supplier`
--
ALTER TABLE `tbl_supplier`
  ADD CONSTRAINT `tbl_supplier_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_support`
--
ALTER TABLE `tbl_support`
  ADD CONSTRAINT `tbl_support_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_task`
--
ALTER TABLE `tbl_task`
  ADD CONSTRAINT `tbl_task_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_taxable_period`
--
ALTER TABLE `tbl_taxable_period`
  ADD CONSTRAINT `tbl_taxable_period_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_tax_filed_monitoring`
--
ALTER TABLE `tbl_tax_filed_monitoring`
  ADD CONSTRAINT `tbl_tax_filed_monitoring_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `tbl_organization` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_trial_balance`
--
ALTER TABLE `tbl_trial_balance`
  ADD CONSTRAINT `tbl_trial_balance_ibfk_1` FOREIGN KEY (`coa_id`) REFERENCES `tbl_coa` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_trial_balance_trans`
--
ALTER TABLE `tbl_trial_balance_trans`
  ADD CONSTRAINT `tbl_trial_balance_trans_ibfk_1` FOREIGN KEY (`trial_balance_id`) REFERENCES `tbl_trial_balance` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_user`
--
ALTER TABLE `tbl_user`
  ADD CONSTRAINT `tbl_user_ibfk_1` FOREIGN KEY (`org_info_id`) REFERENCES `tbl_organization_info` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_users_log`
--
ALTER TABLE `tbl_users_log`
  ADD CONSTRAINT `tbl_users_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_user_access`
--
ALTER TABLE `tbl_user_access`
  ADD CONSTRAINT `tbl_user_access_ibfk_1` FOREIGN KEY (`user_level_id`) REFERENCES `tbl_user_level` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_user_level`
--
ALTER TABLE `tbl_user_level`
  ADD CONSTRAINT `tbl_user_level_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tbl_user_login`
--
ALTER TABLE `tbl_user_login`
  ADD CONSTRAINT `tbl_user_login_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
