<?php
/**
 * Class that operate on table 'tbl_db_version'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-03-21 01:40
 */
class TblDbVersionMySqlDAO implements TblDbVersionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDbVersionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_db_version WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_db_version';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_db_version ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDbVersion primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_db_version WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDbVersionMySql tblDbVersion
 	 */
	public function insert($tblDbVersion){
		$sql = 'INSERT INTO tbl_db_version (user_id, file_name, product, db_version, db_status, db_type, approved_id, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDbVersion->userId);
		$sqlQuery->set($tblDbVersion->fileName);
		$sqlQuery->set($tblDbVersion->product);
		$sqlQuery->set($tblDbVersion->dbVersion);
		$sqlQuery->set($tblDbVersion->dbStatus);
		$sqlQuery->set($tblDbVersion->dbType);
		$sqlQuery->setNumber($tblDbVersion->approvedId);
		$sqlQuery->set($tblDbVersion->createdAt);
		$sqlQuery->set($tblDbVersion->updatedAt);

		$id = $this->executeInsert($sqlQuery);	
		$tblDbVersion->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDbVersionMySql tblDbVersion
 	 */
	public function update($tblDbVersion){
		$sql = 'UPDATE tbl_db_version SET user_id = ?, file_name = ?, product = ?, db_version = ?, db_status = ?, db_type = ?, approved_id = ?, created_at = ?, updated_at = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDbVersion->userId);
		$sqlQuery->set($tblDbVersion->fileName);
		$sqlQuery->set($tblDbVersion->product);
		$sqlQuery->set($tblDbVersion->dbVersion);
		$sqlQuery->set($tblDbVersion->dbStatus);
		$sqlQuery->set($tblDbVersion->dbType);
		$sqlQuery->setNumber($tblDbVersion->approvedId);
		$sqlQuery->set($tblDbVersion->createdAt);
		$sqlQuery->set($tblDbVersion->updatedAt);

		$sqlQuery->setNumber($tblDbVersion->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_db_version';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileName($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProduct($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE product = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDbVersion($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE db_version = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDbStatus($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE db_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDbType($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE db_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApprovedId($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE approved_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedAt($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE created_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUpdatedAt($value){
		$sql = 'SELECT * FROM tbl_db_version WHERE updated_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_db_version WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileName($value){
		$sql = 'DELETE FROM tbl_db_version WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProduct($value){
		$sql = 'DELETE FROM tbl_db_version WHERE product = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDbVersion($value){
		$sql = 'DELETE FROM tbl_db_version WHERE db_version = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDbStatus($value){
		$sql = 'DELETE FROM tbl_db_version WHERE db_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDbType($value){
		$sql = 'DELETE FROM tbl_db_version WHERE db_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApprovedId($value){
		$sql = 'DELETE FROM tbl_db_version WHERE approved_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedAt($value){
		$sql = 'DELETE FROM tbl_db_version WHERE created_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUpdatedAt($value){
		$sql = 'DELETE FROM tbl_db_version WHERE updated_at = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDbVersionMySql 
	 */
	protected function readRow($row){
		$tblDbVersion = new TblDbVersion();
		
		$tblDbVersion->id = $row['id'];
		$tblDbVersion->userId = $row['user_id'];
		$tblDbVersion->fileName = $row['file_name'];
		$tblDbVersion->product = $row['product'];
		$tblDbVersion->dbVersion = $row['db_version'];
		$tblDbVersion->dbStatus = $row['db_status'];
		$tblDbVersion->dbType = $row['db_type'];
		$tblDbVersion->approvedId = $row['approved_id'];
		$tblDbVersion->createdAt = $row['created_at'];
		$tblDbVersion->updatedAt = $row['updated_at'];

		return $tblDbVersion;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDbVersionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>