<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-03-21 01:40
 */
interface TblDbVersionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDbVersion 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDbVersion primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDbVersion tblDbVersion
 	 */
	public function insert($tblDbVersion);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDbVersion tblDbVersion
 	 */
	public function update($tblDbVersion);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByFileName($value);

	public function queryByProduct($value);

	public function queryByDbVersion($value);

	public function queryByDbStatus($value);

	public function queryByDbType($value);

	public function queryByApprovedId($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByUserId($value);

	public function deleteByFileName($value);

	public function deleteByProduct($value);

	public function deleteByDbVersion($value);

	public function deleteByDbStatus($value);

	public function deleteByDbType($value);

	public function deleteByApprovedId($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>