$(function(){
	show();
	seriesLastNum('tbl_transportation_mode','EXP-','#formTransportation','input[name="transportaion_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formTransportation').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveTransportation', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#transportation_table').on('click','.updateTranspoMode',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('transpoModeId');
		var transportaion_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var transportation = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateTransportation').find('input[name="transpo_id"]').val(id);
		$('#updateTransportation').find('input[name="transportaion_no"]').val(transportaion_no);
		$('#updateTransportation').find('input[name="transportation"]').val(transportation);

		if(status == 'enabled'){
			$('#updateTransportation').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateTransportation').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateTransportation').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateTransportation', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#transportation_table');
	$.post(URL+'setup/showTransportation')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.transportationNo+"</td>"+
							"<td>"+a.transportation+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a transpoModeId='"+a.id+"' class='updateTranspoMode btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";
		});
		$('.transpoModeData').html(append);
		$('#transportation_table').DataTable({
			    "ordering": false
		});
	})
}