<?php
/**
 * Class that operate on table 'tbl_leave_credits'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblLeaveCreditsMySqlDAO implements TblLeaveCreditsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveCreditsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave_credits';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave_credits ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveCredit primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave_credits WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveCreditsMySql tblLeaveCredit
 	 */
	public function insert($tblLeaveCredit){
		$sql = 'INSERT INTO tbl_leave_credits (user_id, leave_type_id, total_credits, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCredit->userId);
		$sqlQuery->setNumber($tblLeaveCredit->leaveTypeId);
		$sqlQuery->set($tblLeaveCredit->totalCredits);
		$sqlQuery->setNumber($tblLeaveCredit->createdBy);
		$sqlQuery->setNumber($tblLeaveCredit->modifiedBy);
		$sqlQuery->set($tblLeaveCredit->dateCreated);
		$sqlQuery->set($tblLeaveCredit->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeaveCredit->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveCreditsMySql tblLeaveCredit
 	 */
	public function update($tblLeaveCredit){
		$sql = 'UPDATE tbl_leave_credits SET user_id = ?, leave_type_id = ?, total_credits = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeaveCredit->userId);
		$sqlQuery->setNumber($tblLeaveCredit->leaveTypeId);
		$sqlQuery->set($tblLeaveCredit->totalCredits);
		$sqlQuery->setNumber($tblLeaveCredit->createdBy);
		$sqlQuery->setNumber($tblLeaveCredit->modifiedBy);
		$sqlQuery->set($tblLeaveCredit->dateCreated);
		$sqlQuery->set($tblLeaveCredit->dateModified);

		$sqlQuery->setNumber($tblLeaveCredit->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave_credits';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLeaveTypeId($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE leave_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotalCredits($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_leave_credits WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLeaveTypeId($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE leave_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotalCredits($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE total_credits = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_leave_credits WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveCreditsMySql 
	 */
	protected function readRow($row){
		$tblLeaveCredit = new TblLeaveCredit();
		
		$tblLeaveCredit->id = $row['id'];
		$tblLeaveCredit->userId = $row['user_id'];
		$tblLeaveCredit->leaveTypeId = $row['leave_type_id'];
		$tblLeaveCredit->totalCredits = $row['total_credits'];
		$tblLeaveCredit->createdBy = $row['created_by'];
		$tblLeaveCredit->modifiedBy = $row['modified_by'];
		$tblLeaveCredit->dateCreated = $row['date_created'];
		$tblLeaveCredit->dateModified = $row['date_modified'];

		return $tblLeaveCredit;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveCreditsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>