<?php
/**
 * Class that operate on table 'tbl_engagement_setup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-05-31 07:39
 */
class TblEngagementSetupMySqlDAO implements TblEngagementSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblEngagementSetupMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_engagement_setup';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_engagement_setup ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblEngagementSetup primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagementSetupMySql tblEngagementSetup
 	 */
	public function insert($tblEngagementSetup){
		$sql = 'INSERT INTO tbl_engagement_setup (client_id, client_new_id, engagement_id, client_win_id, scope_of_work_id, setup_no, date_start, date_end, overall_budget_hours, eng_status, status, subdomain, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEngagementSetup->clientId);
		$sqlQuery->setNumber($tblEngagementSetup->clientNewId);
		$sqlQuery->setNumber($tblEngagementSetup->engagementId);
		$sqlQuery->setNumber($tblEngagementSetup->clientWinId);
		$sqlQuery->setNumber($tblEngagementSetup->scopeOfWorkId);
		$sqlQuery->set($tblEngagementSetup->setupNo);
		$sqlQuery->set($tblEngagementSetup->dateStart);
		$sqlQuery->set($tblEngagementSetup->dateEnd);
		$sqlQuery->set($tblEngagementSetup->overallBudgetHours);
		$sqlQuery->set($tblEngagementSetup->engStatus);
		$sqlQuery->set($tblEngagementSetup->status);
		$sqlQuery->set($tblEngagementSetup->subdomain);
		$sqlQuery->setNumber($tblEngagementSetup->createdBy);
		$sqlQuery->setNumber($tblEngagementSetup->modifiedBy);
		$sqlQuery->set($tblEngagementSetup->dateCreated);
		$sqlQuery->set($tblEngagementSetup->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblEngagementSetup->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagementSetupMySql tblEngagementSetup
 	 */
	public function update($tblEngagementSetup){
		$sql = 'UPDATE tbl_engagement_setup SET client_id = ?, client_new_id = ?, engagement_id = ?, client_win_id = ?, scope_of_work_id = ?, setup_no = ?, date_start = ?, date_end = ?, overall_budget_hours = ?, eng_status = ?, status = ?, subdomain = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEngagementSetup->clientId);
		$sqlQuery->setNumber($tblEngagementSetup->clientNewId);
		$sqlQuery->setNumber($tblEngagementSetup->engagementId);
		$sqlQuery->setNumber($tblEngagementSetup->clientWinId);
		$sqlQuery->setNumber($tblEngagementSetup->scopeOfWorkId);
		$sqlQuery->set($tblEngagementSetup->setupNo);
		$sqlQuery->set($tblEngagementSetup->dateStart);
		$sqlQuery->set($tblEngagementSetup->dateEnd);
		$sqlQuery->set($tblEngagementSetup->overallBudgetHours);
		$sqlQuery->set($tblEngagementSetup->engStatus);
		$sqlQuery->set($tblEngagementSetup->status);
		$sqlQuery->set($tblEngagementSetup->subdomain);
		$sqlQuery->setNumber($tblEngagementSetup->createdBy);
		$sqlQuery->setNumber($tblEngagementSetup->modifiedBy);
		$sqlQuery->set($tblEngagementSetup->dateCreated);
		$sqlQuery->set($tblEngagementSetup->dateModified);

		$sqlQuery->setNumber($tblEngagementSetup->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_engagement_setup';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientNewId($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE client_new_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngagementId($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientWinId($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE client_win_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByScopeOfWorkId($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE scope_of_work_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySetupNo($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE setup_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateStart($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE date_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateEnd($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE date_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOverallBudgetHours($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE overall_budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngStatus($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE eng_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_engagement_setup WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientId($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientNewId($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE client_new_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngagementId($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientWinId($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE client_win_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByScopeOfWorkId($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE scope_of_work_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySetupNo($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE setup_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateStart($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE date_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateEnd($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE date_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOverallBudgetHours($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE overall_budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngStatus($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE eng_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_engagement_setup WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblEngagementSetupMySql 
	 */
	protected function readRow($row){
		$tblEngagementSetup = new TblEngagementSetup();
		
		$tblEngagementSetup->id = $row['id'];
		$tblEngagementSetup->clientId = $row['client_id'];
		$tblEngagementSetup->clientNewId = $row['client_new_id'];
		$tblEngagementSetup->engagementId = $row['engagement_id'];
		$tblEngagementSetup->clientWinId = $row['client_win_id'];
		$tblEngagementSetup->scopeOfWorkId = $row['scope_of_work_id'];
		$tblEngagementSetup->setupNo = $row['setup_no'];
		$tblEngagementSetup->dateStart = $row['date_start'];
		$tblEngagementSetup->dateEnd = $row['date_end'];
		$tblEngagementSetup->overallBudgetHours = $row['overall_budget_hours'];
		$tblEngagementSetup->engStatus = $row['eng_status'];
		$tblEngagementSetup->status = $row['status'];
		$tblEngagementSetup->subdomain = $row['subdomain'];
		$tblEngagementSetup->createdBy = $row['created_by'];
		$tblEngagementSetup->modifiedBy = $row['modified_by'];
		$tblEngagementSetup->dateCreated = $row['date_created'];
		$tblEngagementSetup->dateModified = $row['date_modified'];

		return $tblEngagementSetup;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblEngagementSetupMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>