<?php
/**
 * Class that operate on table 'tbl_client_win'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
class TblClientWinMySqlDAO implements TblClientWinDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblClientWinMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_client_win WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_client_win';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_client_win ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblClientWin primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_client_win WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientWinMySql tblClientWin
 	 */
	public function insert($tblClientWin){
		$sql = 'INSERT INTO tbl_client_win (client_new_id, key_accounts_id, client_win_no, amount, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblClientWin->clientNewId);
		$sqlQuery->setNumber($tblClientWin->keyAccountsId);
		$sqlQuery->set($tblClientWin->clientWinNo);
		$sqlQuery->set($tblClientWin->amount);
		$sqlQuery->setNumber($tblClientWin->createdBy);
		$sqlQuery->setNumber($tblClientWin->modifiedBy);
		$sqlQuery->set($tblClientWin->dateCreated);
		$sqlQuery->set($tblClientWin->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblClientWin->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientWinMySql tblClientWin
 	 */
	public function update($tblClientWin){
		$sql = 'UPDATE tbl_client_win SET client_new_id = ?, key_accounts_id = ?, client_win_no = ?, amount = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblClientWin->clientNewId);
		$sqlQuery->setNumber($tblClientWin->keyAccountsId);
		$sqlQuery->set($tblClientWin->clientWinNo);
		$sqlQuery->set($tblClientWin->amount);
		$sqlQuery->setNumber($tblClientWin->createdBy);
		$sqlQuery->setNumber($tblClientWin->modifiedBy);
		$sqlQuery->set($tblClientWin->dateCreated);
		$sqlQuery->set($tblClientWin->dateModified);

		$sqlQuery->setNumber($tblClientWin->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_client_win';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientNewId($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE client_new_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByKeyAccountsId($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE key_accounts_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientWinNo($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE client_win_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAmount($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE amount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_client_win WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientNewId($value){
		$sql = 'DELETE FROM tbl_client_win WHERE client_new_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByKeyAccountsId($value){
		$sql = 'DELETE FROM tbl_client_win WHERE key_accounts_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientWinNo($value){
		$sql = 'DELETE FROM tbl_client_win WHERE client_win_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAmount($value){
		$sql = 'DELETE FROM tbl_client_win WHERE amount = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_client_win WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_client_win WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_client_win WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_client_win WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblClientWinMySql 
	 */
	protected function readRow($row){
		$tblClientWin = new TblClientWin();
		
		$tblClientWin->id = $row['id'];
		$tblClientWin->clientNewId = $row['client_new_id'];
		$tblClientWin->keyAccountsId = $row['key_accounts_id'];
		$tblClientWin->clientWinNo = $row['client_win_no'];
		$tblClientWin->amount = $row['amount'];
		$tblClientWin->createdBy = $row['created_by'];
		$tblClientWin->modifiedBy = $row['modified_by'];
		$tblClientWin->dateCreated = $row['date_created'];
		$tblClientWin->dateModified = $row['date_modified'];

		return $tblClientWin;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblClientWinMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>