<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-05-31 07:39
 */
interface TblEngagementSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEngagementSetup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEngagementSetup primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagementSetup tblEngagementSetup
 	 */
	public function insert($tblEngagementSetup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagementSetup tblEngagementSetup
 	 */
	public function update($tblEngagementSetup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByClientNewId($value);

	public function queryByEngagementId($value);

	public function queryByClientWinId($value);

	public function queryByScopeOfWorkId($value);

	public function queryBySetupNo($value);

	public function queryByDateStart($value);

	public function queryByDateEnd($value);

	public function queryByOverallBudgetHours($value);

	public function queryByEngStatus($value);

	public function queryByStatus($value);

	public function queryBySubdomain($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByClientId($value);

	public function deleteByClientNewId($value);

	public function deleteByEngagementId($value);

	public function deleteByClientWinId($value);

	public function deleteByScopeOfWorkId($value);

	public function deleteBySetupNo($value);

	public function deleteByDateStart($value);

	public function deleteByDateEnd($value);

	public function deleteByOverallBudgetHours($value);

	public function deleteByEngStatus($value);

	public function deleteByStatus($value);

	public function deleteBySubdomain($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>