<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-15 03:15
 */
interface TblClientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClient 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClient tblClient
 	 */
	public function insert($tblClient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClient tblClient
 	 */
	public function update($tblClient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientNo($value);

	public function queryByClient($value);

	public function queryByKeyAccountsId($value);

	public function queryByContractPrice($value);

	public function queryByType($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByClientNo($value);

	public function deleteByClient($value);

	public function deleteByKeyAccountsId($value);

	public function deleteByContractPrice($value);

	public function deleteByType($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>