<?php
/**
 * Class that operate on table 'tbl_dpr_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblDprTransactionMySqlDAO implements TblDprTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDprTransactionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_dpr_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_dpr_transaction ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDprTransaction primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDprTransactionMySql tblDprTransaction
 	 */
	public function insert($tblDprTransaction){
		$sql = 'INSERT INTO tbl_dpr_transaction (user_id, date, date_submit, major_accomplishment, issue_concern, status, posted_id, transpo_reimburse) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDprTransaction->userId);
		$sqlQuery->set($tblDprTransaction->date);
		$sqlQuery->set($tblDprTransaction->dateSubmit);
		$sqlQuery->set($tblDprTransaction->majorAccomplishment);
		$sqlQuery->set($tblDprTransaction->issueConcern);
		$sqlQuery->set($tblDprTransaction->status);
		$sqlQuery->setNumber($tblDprTransaction->postedId);
		$sqlQuery->set($tblDprTransaction->transpoReimburse);

		$id = $this->executeInsert($sqlQuery);	
		$tblDprTransaction->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDprTransactionMySql tblDprTransaction
 	 */
	public function update($tblDprTransaction){
		$sql = 'UPDATE tbl_dpr_transaction SET user_id = ?, date = ?, date_submit = ?, major_accomplishment = ?, issue_concern = ?, status = ?, posted_id = ?, transpo_reimburse = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDprTransaction->userId);
		$sqlQuery->set($tblDprTransaction->date);
		$sqlQuery->set($tblDprTransaction->dateSubmit);
		$sqlQuery->set($tblDprTransaction->majorAccomplishment);
		$sqlQuery->set($tblDprTransaction->issueConcern);
		$sqlQuery->set($tblDprTransaction->status);
		$sqlQuery->setNumber($tblDprTransaction->postedId);
		$sqlQuery->set($tblDprTransaction->transpoReimburse);

		$sqlQuery->setNumber($tblDprTransaction->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_dpr_transaction';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateSubmit($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE date_submit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMajorAccomplishment($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE major_accomplishment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByIssueConcern($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE issue_concern = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPostedId($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE posted_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTranspoReimburse($value){
		$sql = 'SELECT * FROM tbl_dpr_transaction WHERE transpo_reimburse = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateSubmit($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE date_submit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMajorAccomplishment($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE major_accomplishment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByIssueConcern($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE issue_concern = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPostedId($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE posted_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTranspoReimburse($value){
		$sql = 'DELETE FROM tbl_dpr_transaction WHERE transpo_reimburse = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDprTransactionMySql 
	 */
	protected function readRow($row){
		$tblDprTransaction = new TblDprTransaction();
		
		$tblDprTransaction->id = $row['id'];
		$tblDprTransaction->userId = $row['user_id'];
		$tblDprTransaction->date = $row['date'];
		$tblDprTransaction->dateSubmit = $row['date_submit'];
		$tblDprTransaction->majorAccomplishment = $row['major_accomplishment'];
		$tblDprTransaction->issueConcern = $row['issue_concern'];
		$tblDprTransaction->status = $row['status'];
		$tblDprTransaction->postedId = $row['posted_id'];
		$tblDprTransaction->transpoReimburse = $row['transpo_reimburse'];

		return $tblDprTransaction;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDprTransactionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>