<?php
/**
 * Class that operate on table 'tbl_default_activities'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblDefaultActivitiesMySqlDAO implements TblDefaultActivitiesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDefaultActivitiesMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_default_activities WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_default_activities';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_default_activities ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDefaultActivitie primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_default_activities WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDefaultActivitiesMySql tblDefaultActivitie
 	 */
	public function insert($tblDefaultActivitie){
		$sql = 'INSERT INTO tbl_default_activities (company, group_id, act_id, engagement_type) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDefaultActivitie->company);
		$sqlQuery->setNumber($tblDefaultActivitie->groupId);
		$sqlQuery->setNumber($tblDefaultActivitie->actId);
		$sqlQuery->setNumber($tblDefaultActivitie->engagementType);

		$id = $this->executeInsert($sqlQuery);	
		$tblDefaultActivitie->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDefaultActivitiesMySql tblDefaultActivitie
 	 */
	public function update($tblDefaultActivitie){
		$sql = 'UPDATE tbl_default_activities SET company = ?, group_id = ?, act_id = ?, engagement_type = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDefaultActivitie->company);
		$sqlQuery->setNumber($tblDefaultActivitie->groupId);
		$sqlQuery->setNumber($tblDefaultActivitie->actId);
		$sqlQuery->setNumber($tblDefaultActivitie->engagementType);

		$sqlQuery->setNumber($tblDefaultActivitie->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_default_activities';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByCompany($value){
		$sql = 'SELECT * FROM tbl_default_activities WHERE company = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGroupId($value){
		$sql = 'SELECT * FROM tbl_default_activities WHERE group_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActId($value){
		$sql = 'SELECT * FROM tbl_default_activities WHERE act_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngagementType($value){
		$sql = 'SELECT * FROM tbl_default_activities WHERE engagement_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByCompany($value){
		$sql = 'DELETE FROM tbl_default_activities WHERE company = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGroupId($value){
		$sql = 'DELETE FROM tbl_default_activities WHERE group_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActId($value){
		$sql = 'DELETE FROM tbl_default_activities WHERE act_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngagementType($value){
		$sql = 'DELETE FROM tbl_default_activities WHERE engagement_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDefaultActivitiesMySql 
	 */
	protected function readRow($row){
		$tblDefaultActivitie = new TblDefaultActivitie();
		
		$tblDefaultActivitie->id = $row['id'];
		$tblDefaultActivitie->company = $row['company'];
		$tblDefaultActivitie->groupId = $row['group_id'];
		$tblDefaultActivitie->actId = $row['act_id'];
		$tblDefaultActivitie->engagementType = $row['engagement_type'];

		return $tblDefaultActivitie;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDefaultActivitiesMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>