<?php
/**
 * Class that operate on table 'tbl_attendance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblAttendanceMySqlDAO implements TblAttendanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblAttendanceMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_attendance WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_attendance';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_attendance ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblAttendance primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_attendance WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblAttendanceMySql tblAttendance
 	 */
	public function insert($tblAttendance){
		$sql = 'INSERT INTO tbl_attendance (employee, project, activity, time, time_out, officialTime, hoursCode, note, note_out, location, location_out, status, absent, late, holiday, status_type, client, submit, submit_out) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblAttendance->employee);
		$sqlQuery->setNumber($tblAttendance->project);
		$sqlQuery->setNumber($tblAttendance->activity);
		$sqlQuery->set($tblAttendance->time);
		$sqlQuery->set($tblAttendance->timeOut);
		$sqlQuery->set($tblAttendance->officialTime);
		$sqlQuery->set($tblAttendance->hoursCode);
		$sqlQuery->set($tblAttendance->note);
		$sqlQuery->set($tblAttendance->noteOut);
		$sqlQuery->set($tblAttendance->location);
		$sqlQuery->set($tblAttendance->locationOut);
		$sqlQuery->set($tblAttendance->status);
		$sqlQuery->set($tblAttendance->absent);
		$sqlQuery->set($tblAttendance->late);
		$sqlQuery->set($tblAttendance->holiday);
		$sqlQuery->set($tblAttendance->statusType);
		$sqlQuery->setNumber($tblAttendance->client);
		$sqlQuery->set($tblAttendance->submit);
		$sqlQuery->set($tblAttendance->submitOut);

		$id = $this->executeInsert($sqlQuery);	
		$tblAttendance->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblAttendanceMySql tblAttendance
 	 */
	public function update($tblAttendance){
		$sql = 'UPDATE tbl_attendance SET employee = ?, project = ?, activity = ?, time = ?, time_out = ?, officialTime = ?, hoursCode = ?, note = ?, note_out = ?, location = ?, location_out = ?, status = ?, absent = ?, late = ?, holiday = ?, status_type = ?, client = ?, submit = ?, submit_out = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblAttendance->employee);
		$sqlQuery->setNumber($tblAttendance->project);
		$sqlQuery->setNumber($tblAttendance->activity);
		$sqlQuery->set($tblAttendance->time);
		$sqlQuery->set($tblAttendance->timeOut);
		$sqlQuery->set($tblAttendance->officialTime);
		$sqlQuery->set($tblAttendance->hoursCode);
		$sqlQuery->set($tblAttendance->note);
		$sqlQuery->set($tblAttendance->noteOut);
		$sqlQuery->set($tblAttendance->location);
		$sqlQuery->set($tblAttendance->locationOut);
		$sqlQuery->set($tblAttendance->status);
		$sqlQuery->set($tblAttendance->absent);
		$sqlQuery->set($tblAttendance->late);
		$sqlQuery->set($tblAttendance->holiday);
		$sqlQuery->set($tblAttendance->statusType);
		$sqlQuery->setNumber($tblAttendance->client);
		$sqlQuery->set($tblAttendance->submit);
		$sqlQuery->set($tblAttendance->submitOut);

		$sqlQuery->setNumber($tblAttendance->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_attendance';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEmployee($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE employee = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProject($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE project = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActivity($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTime($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeOut($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOfficialTime($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE officialTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHoursCode($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE hoursCode = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNote($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE note = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByNoteOut($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE note_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLocation($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE location = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLocationOut($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE location_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAbsent($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE absent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLate($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE late = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHoliday($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE holiday = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatusType($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE status_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubmit($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE submit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubmitOut($value){
		$sql = 'SELECT * FROM tbl_attendance WHERE submit_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEmployee($value){
		$sql = 'DELETE FROM tbl_attendance WHERE employee = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProject($value){
		$sql = 'DELETE FROM tbl_attendance WHERE project = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActivity($value){
		$sql = 'DELETE FROM tbl_attendance WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTime($value){
		$sql = 'DELETE FROM tbl_attendance WHERE time = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeOut($value){
		$sql = 'DELETE FROM tbl_attendance WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOfficialTime($value){
		$sql = 'DELETE FROM tbl_attendance WHERE officialTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHoursCode($value){
		$sql = 'DELETE FROM tbl_attendance WHERE hoursCode = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNote($value){
		$sql = 'DELETE FROM tbl_attendance WHERE note = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByNoteOut($value){
		$sql = 'DELETE FROM tbl_attendance WHERE note_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLocation($value){
		$sql = 'DELETE FROM tbl_attendance WHERE location = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLocationOut($value){
		$sql = 'DELETE FROM tbl_attendance WHERE location_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_attendance WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAbsent($value){
		$sql = 'DELETE FROM tbl_attendance WHERE absent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLate($value){
		$sql = 'DELETE FROM tbl_attendance WHERE late = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHoliday($value){
		$sql = 'DELETE FROM tbl_attendance WHERE holiday = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatusType($value){
		$sql = 'DELETE FROM tbl_attendance WHERE status_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM tbl_attendance WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubmit($value){
		$sql = 'DELETE FROM tbl_attendance WHERE submit = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubmitOut($value){
		$sql = 'DELETE FROM tbl_attendance WHERE submit_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblAttendanceMySql 
	 */
	protected function readRow($row){
		$tblAttendance = new TblAttendance();
		
		$tblAttendance->id = $row['id'];
		$tblAttendance->employee = $row['employee'];
		$tblAttendance->project = $row['project'];
		$tblAttendance->activity = $row['activity'];
		$tblAttendance->time = $row['time'];
		$tblAttendance->timeOut = $row['time_out'];
		$tblAttendance->officialTime = $row['officialTime'];
		$tblAttendance->hoursCode = $row['hoursCode'];
		$tblAttendance->note = $row['note'];
		$tblAttendance->noteOut = $row['note_out'];
		$tblAttendance->location = $row['location'];
		$tblAttendance->locationOut = $row['location_out'];
		$tblAttendance->status = $row['status'];
		$tblAttendance->absent = $row['absent'];
		$tblAttendance->late = $row['late'];
		$tblAttendance->holiday = $row['holiday'];
		$tblAttendance->statusType = $row['status_type'];
		$tblAttendance->client = $row['client'];
		$tblAttendance->submit = $row['submit'];
		$tblAttendance->submitOut = $row['submit_out'];

		return $tblAttendance;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblAttendanceMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>